/*
 * Copyright 1997-2003 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail.internet;

import java.util.Enumeration;

import javax.mail.MessagingException;
import javax.mail.Part;

/**
 * MimePart C^tF[X́AMIME (RFC2045, Section 2.4) Œ` <strong>Entity</strong> f܂B<p>
 * 
 * MimePart  Part C^tF[XgA⑫I RFC822 y MIME ŗL̃Z}eBNXƑǉ܂B
 *  MimeMessage y MimeBodyPart NX̊{C^tF[X񋟂܂B
 * 
 * <hr> <strong>RFC822 y MIME wb_Ɋւ郁</strong><p>
 * 
 * RFC822 y MIME wb_tB[h US-ASCII ܂܂Ȃ<strong>Ȃ܂</strong>B
 * wb_ US-ASCII ȊO̕܂ޏꍇARFC 2047 ̋Kɏ]ăGR[hȂ΂Ȃ܂B
 * ̃pbP[WŒ񋟂 MimeUtility NXpĂsł܂B
 * <code>setHeader</code>A<code>addHeader</code>Ay <code>addHeaderLine</code> \bȟĂяóA
 * w肳ꂽwb_ MIME vɏ]ۏ؂Kv܂B
 * Ãwb_tB[h]ɂs̒ (SMTP ̏ꍇ 1000oCg) 𒴂ꍇ́A
 * M̑Oɐ܂肽 (bv) Kv܂B
 * Mwb_͐܂肽܂Ă\܂B
 * AvP[V̓wb_K؂ɐ܂肽݁AWJӔC܂B<p>
 * 
 * @see MimeUtility
 * @see javax.mail.Part
 */
public interface MimePart extends Part {

	/**
	 * ̃wb_ɂĎgp\ȑSẴwb_tB[h̒l擾A
	 * ؂蕶ŋ؂ꂽlP String ƂĕԂ܂A
	 * ؂蕶 <code>null</code> ̏ꍇ́Aŏ̒lԂ܂B
	 * 
	 * @param name ̃wb_̖O
	 * @param delimiter delimiter between fields in returned string
	 * @return ̖OSẴwb_ɑ΂ltB[h 
	 * @throws MessagingException
	 */
	public String getHeader(String name, String delimiter) throws MessagingException;

	/**
	 *  RFC822 wb_sǉ܂B
	 * 
	 * @throws IllegalWriteException ύXT|[gȂꍇ
	 * @throws IllegalStateException  Part  READ_ONLY tH_擾ꂽꍇ
	 */
	public void addHeaderLine(String line) throws MessagingException;

	/**
	 * SẴwb_s String ̗񋓌^ƂĎ擾܂B
	 * Header s͐ RFC822 wb_słA"name" y "value" ̗tB[h܂݂܂B
	 */
	public Enumeration getAllHeaderLines() throws MessagingException;

	/**
	 * vwb_s String ̗񋓌^ƂĎ擾܂B
	 * Header s͐ RFC822 wb_słA"name" y "value" ̗tB[h܂݂܂B
	 */
	public Enumeration getMatchingHeaderLines(String[] names) throws MessagingException;

	/**
	 * vȂwb_s String ̗񋓌^ƂĎ擾܂B
	 * Header s͐ RFC822 wb_słA"name" y "value" ̗tB[h܂݂܂B
	 */
	public Enumeration getNonMatchingHeaderLines(String[] names) throws MessagingException;

	/**
	 * ̓̕]GR[fBO擾܂B
	 * 
	 * @return e]GR[fBO
	 * @throws MessagingException
	 */
	public String getEncoding() throws MessagingException;

	/**
	 * ̕ Content-ID 擾܂B݂Ȃꍇ null Ԃ܂B
	 * 
	 * @return Rec ID
	 */
	public String getContentID() throws MessagingException;

	/**
	 * ̕ Content-MD5 _CWFXg擾܂B
	 * ݂Ȃꍇ null Ԃ܂B
	 * 
	 * @return Rec MD5
	 */
	public String getContentMD5() throws MessagingException;

	/**
	 * ̕ Content-MD5 ݒ肵܂B
	 * 
	 * @param md5 Rec ID
	 * @throws IllegalWriteException ύXT|[gȂꍇ
	 * @throws IllegalStateException  Part  READ_ONLY tH_擾ꂽꍇ
	 */
	public void setContentMD5(String md5) throws MessagingException;

	/**
	 *  MimePart  Content-Language wb_Ŏw肳錾^O擾܂B
	 * Content-Language wb_ RFC 1766 ɂ`܂B
	 * ̃wb_gpłȂꍇ <code>null</code> Ԃ܂B
	 */
	public String[] getContentLanguage() throws MessagingException;

	/**
	 *  MimePart  Content-Language wb_ݒ肵܂B
	 * Content-Language wb_ RFC1766 ɂ`܂B
	 * 
	 * @param languages ^O̔z
	 * @throws IllegalWriteException ύXT|[gȂꍇ
	 * @throws IllegalStateException  Part  READ_ONLY tH_擾ꂽꍇ
	 */
	public void setContentLanguage(String[] languages) throws MessagingException;

	/**
	 * w肳ꂽ String ̃̕RecƂāA
	 * "text/plain"  MIME ^CvŐݒ肷ȈՃ\bhłB
	 *  US-ASCII ȊO̕܂܂ꍇA
	 * vbgtH[̃ftHg̕ZbggpăGR[h܂B
	 * ̕Zbg "charset" p[^ݒ肷ׂɂgp܂B<p>
	 * 
	 * ̃\bh͎gp镶Zbg߂ׂɑSĂ̕𑖍Ȃ΂ȂȂꍇ̂ŁA
	 * text 傫ꍇ́A\ቺ\鎖ɒӂĉB<p>
	 * 
	 * Zbgm̏ꍇAZbgp[^󂯎 setText() o[WgpĉB
	 * 
	 * @see #setText(String text, String charset)
	 */
	public void setText(String text) throws MessagingException;

	/**
	 * "text/plain"  MIME ^Cvyюw肳ꂽZbggpA
	 * w肳ꂽ String ̃̕RecƂĐݒ肷ȈՃ\bhłB
	 * w肳ꂽ Unicode ͎w肳ꂽZbggpĕZbgGR[h܂B
	 * ̕Zbg "charset" p[^ݒ肷ׂɂgp܂B
	 * 
	 * @param text the text content to set
	 * @param charset the charset to use for the text
	 * @throws MessagingException if an error occurs
	 */
	public void setText(String text, String charset) throws MessagingException;

	/**
	 * "text"  MIME ^Cvyюw肳ꂽ MIME Tu^CvgpA
	 * w肳ꂽ String ̃̕RecƂĐݒ肷ȈՃ\bhłB
	 * w肳ꂽ Unicode ͎w肳ꂽZbggpĕZbgGR[h܂B
	 * ̕Zbg "charset" p[^ݒ肷ׂɂgp܂B
	 * 
	 * @param text the text content to set
	 * @param charset the charset to use for the text
	 * @param subtype the MIME subtype to use (e.g., "html")
	 * @throws MessagingException if an error occurs
	 * @since JavaMail 1.4
	 */
	public void setText(String text, String charset, String subtype) throws MessagingException;

}
