/*
 * Copyright 1997-2000 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail.internet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownServiceException;

import javax.activation.DataSource;
import javax.mail.MessageAware;
import javax.mail.MessageContext;
import javax.mail.MessagingException;

/**
 * MimePart  DataSource 郆[eBeBNXłB
 * ̃NX͎ɃT[rXvoC_ΏۂɂĂ܂B
 * 
 * @see javax.mail.internet.MimePart
 * @see javax.activation.DataSource
 */
public class MimePartDataSource implements DataSource, MessageAware {

	private static boolean ignoreMultipartEncoding = true;
	static {
		try {
			String s = System.getProperty("mail.mime.ignoremultipartencoding");
			ignoreMultipartEncoding = s == null || !s.equalsIgnoreCase("false");
		} catch (SecurityException _ex) {}
	}

	/**
	 * The MimePart that provides the data for this DataSource.
	 * 
	 * @since JavaMail 1.4
	 */
	protected MimePart part;

	private MessageContext context;

	/**
	 * MimePart  DataSource \zRXgN^łB
	 */
	public MimePartDataSource(final MimePart part) {
		this.part = part;
	}

	/**
	 *  MimePart ̓̓Xg[Ԃ܂B<p>
	 * 
	 * ̃\bh́A MimePart  Content-Transfer-Encoding ɊÂA
	 * K؂ȓ]fR[fBOKp܂Bׁ̈AԂ̓Xg[́A
	 * fR[hꂽoCgXg[łB<p>
	 * 
	 * ̎́A<code>getContentStream()</code> \bhgp Part 琶̃Rec擾A
	 * <code>MimeUtility.decode()</code> \bhgpăfR[h܂B
	 * 
	 * @return fR[hꂽ̓Xg[
	 * @see javax.mail.internet.MimeMessage#getContentStream
	 * @see javax.mail.internet.MimeBodyPart#getContentStream
	 * @see javax.mail.internet.MimeUtility#decode
	 */
	public final InputStream getInputStream() throws IOException {
		try {
			InputStream is;
			if (part instanceof MimeBodyPart)
				is = ((MimeBodyPart)part).getContentStream();
			else if (part instanceof MimeMessage)
				is = ((MimeMessage)part).getContentStream();
			else
				throw new MessagingException("Unknown part");

			String encoding = restrictEncoding(part.getEncoding(), part);
			if (encoding != null)
				return MimeUtility.decode(is, encoding);
			return is;
		} catch (MessagingException mex) {
			throw new IOException(mex.getMessage());
		}
	}

	private static String restrictEncoding(final String s, final MimePart mimepart) throws MessagingException {
		if (!ignoreMultipartEncoding || s == null)
			return s;
		if (s.equalsIgnoreCase("7bit") || s.equalsIgnoreCase("8bit") || s.equalsIgnoreCase("binary"))
			return s;
		String s1 = mimepart.getContentType();
		if(s1 == null)
			return s;
		try {
			ContentType contenttype = new ContentType(s1);
			if (contenttype.match("multipart/*") || contenttype.match("message/*"))
				return null;
		} catch (ParseException _ex) {}
		return s;
	}

	/**
	 * o̓Xg[Ԃ߂ DataSource \bhłB<p>
	 * 
	 * ̎ UnknownServiceException X[܂B
	 */
	public final OutputStream getOutputStream() throws IOException {
		throw new UnknownServiceException();
	}

	/**
	 *  DataSource ̃Rec`Ԃ܂B<p>
	 * 
	 * ̎ MimePart  <code>getContentType</code> \bhĂяołB
	 */
	public final String getContentType() {
		try {
			return part.getContentType();
		} catch (MessagingException mex) {
			return null;
		}
	}

	/**
	 * OԂ߂ DataSource \bhłB<p>
	 * 
	 * ̎͋̕ԂłB
	 */
	public final String getName() {
		try {
			if (part instanceof MimeBodyPart)
				return ((MimeBodyPart)part).getFileName();
		} catch (MessagingException mex) {}	// 
		return "";
	}

	/**
	 * ݂̃p[g <code>MessageContext</code> Ԃ܂B
	 * 
	 * @since JavaMail 1.1
	 */
	public synchronized final MessageContext getMessageContext() {
		if (context == null)
			context = new MessageContext(part);
		return context;
	}

}
