/*
 * Copyright 1998, 1999 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail.internet;

import java.util.StringTokenizer;
import java.util.Vector;

import javax.mail.Address;

/**
 * ̃NX RFC1036 j[XO[vAhXf܂B
 */
public final class NewsAddress extends Address {

	private static final long serialVersionUID = -4203797299824684143L;

	protected String newsgroup;
	protected String host;	// may be null

	/**
	 * ftHgRXgN^łB
	 */
	public NewsAddress() {}

	/**
	 * w肳ꂽj[XO[v NewsAddress \z܂B
	 * 
	 * @param newsgroup j[XO[v
	 */
	public NewsAddress(final String newsgroup) {
		this(newsgroup, null);
	}

	/**
	 * w肳ꂽj[XO[vƃzXg NewsAddress \z܂B
	 * 
	 * @param newsgroup j[XO[v
	 * @param host zXg
	 */
	public NewsAddress(final String newsgroup, final String host) {
		this.newsgroup = newsgroup;
		this.host = host;
	}

	/**
	 * ̃AhX̌^Ԃ܂BNewsAddress ̌^ "news" łB
	 */
	public String getType() {
		return "news";
	}

	/**
	 * j[XO[vݒ肵܂B
	 * 
	 * @param newsgroup j[XO[v
	 */
	public void setNewsgroup(final String newsgroup) {
		this.newsgroup = newsgroup;
	}

	/**
	 * j[XO[v擾܂B
	 * 
	 * @return j[XO[v
	 */
	public String getNewsgroup() {
		return newsgroup;
	}

	/**
	 * zXgݒ肵܂B
	 * 
	 * @param host zXg
	 */
	public void setHost(final String host) {
		this.host = host;
	}

	/**
	 * zXg擾܂B
	 * 
	 * @return zXg
	 */
	public String getHost() {
		return host;
	}

	/**
	 * ̃AhX RFC 1036 AhXɕϊ܂B
	 * 
	 * @return j[XO[v
	 */
	public String toString() {
		return newsgroup;
	}

	/**
	 * ZqłB
	 */
	public boolean equals(final Object a) {
		if (!(a instanceof NewsAddress))
			return false;

		NewsAddress s = (NewsAddress) a;
		return newsgroup.equals(s.newsgroup) && ((host == null && s.host == null) || (host != null && s.host != null && host.equalsIgnoreCase(s.host)));
	}

	/**
	 * AhX̃nbVR[hvZ܂B
	 */
	public int hashCode() {
		int hash = 0;
		if (newsgroup != null)
			hash += newsgroup.hashCode();
		if (host != null)
			hash += host.toLowerCase().hashCode();
		return hash;
	}

	/**
	 * w肳ꂽ NewsAddress IuWFNg̔zAhX̃R}؂V[PXɕϊ܂B
	 * ϊ̕ɂ US-ASCII ܂܂ׁA[ňSɎgpł܂B
	 * 
	 * @param addresses NewsAddress IuWFNg̔z
	 * @return R}؂̃AhX
	 * @throws ClassCastException w肳ꂽz̉ꂩ̃AhXIuWFNg NewsAddress IuWFNgłȂꍇB
	 *  RuntimeException ł鎖ɒӂĉB
	 */
	public static String toString(final Address[] addresses) {
		if (addresses == null || addresses.length == 0)
			return null;

		StringBuffer s = new StringBuffer(((NewsAddress)addresses[0]).toString());
		for (int i = 1; i < addresses.length; i++)
			s.append(',').append(((NewsAddress)addresses[i]).toString());

		return s.toString();
	}

	/**
	 * w肳ꂽR}؂̃j[XO[ṽV[PX NewsAddress IuWFNgɍ\͂܂B
	 * 
	 * @param newsgroups R}؂̃j[XO[v
	 * @return NewsAddress IuWFNg̔z
	 * @throws AddressException \͂Ɏsꍇ
	 */
	public static NewsAddress[] parse(final String newsgroups) /* throws AddressException */ {
		// XXX - verify format of newsgroup name?
		StringTokenizer st = new StringTokenizer(newsgroups, ",");
		Vector nglist = new Vector();
		while (st.hasMoreTokens()) {
			String ng = st.nextToken();
			nglist.addElement(new NewsAddress(ng));
		}
		int size = nglist.size();
		NewsAddress[] na = new NewsAddress[size];
		if (size > 0)
			nglist.copyInto(na);
		return na;
	}

}
