/*
 * Copyright 1997-2004 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail.internet;

import java.io.InputStream;

/**
 * ̏Ńf[^L InputStream ́ÃC^tF[Xꍇ܂B
 * ɂA InputStream ̃[ÚAInputStream ݂̌̈ʒuʂA
 *  InputStreams ̃f[^̃TuZbg\V InputStream 쐬ł܂B
 * V InputStream ́Af[^Rs[邱ƂȂAƓf[^ɃANZX܂B<p>
 * 
 * Note that implementations of this interface must ensure that the
 * <code>close</code> method does not close any underlying stream
 * that might be shared by multiple instances of <code>SharedInputStream</code>
 * until all shared instances have been closed.
 * 
 * @since JavaMail 1.2
 */
public interface SharedInputStream {

	/**
	 * InputStream ݈̌ʒu InputStream ̐擪̃ItZbgŕԂ܂B
	 * 
	 * @return ݂̈ʒu
	 */
	public long getPosition();

	/**
	 *  InputStream ̃f[^̃TuZbg\V InputStream Ԃ܂B
	 *  <code>start</code> (܂) n܂A<code>end</code> (܂܂Ȃ) ŏI܂B
	 * <code>start</code> ͕łĂ͂Ȃ܂B<code>end</code>  -1 ̏ꍇA
	 * VXg[͂̃Xg[ƓꏊŏI܂B
	 * Ԃ InputStream  SharedInputStream C^tF[X܂B
	 * 
	 * @param start Jnʒu
	 * @param end Iʒu + 1
	 * @return VXg[
	 */
	public InputStream newStream(long start, long end);

}
