/*
 * Copyright 1998-2000 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail.search;

import javax.mail.Address;
import javax.mail.internet.InternetAddress;

/**
 * ̒ۃNX́AMessage AhX̕r܂B<p>
 * 
 * ̃NX <code>AddressTerm</code> NXƈقȂ鎖ɒӂĉB
 * ̃NX Address IuWFNgł͂ȂAAhXɂĔrs܂B
 * 
 * @since JavaMail 1.1
 */
public abstract class AddressStringTerm extends StringTerm {

	private static final long serialVersionUID = 3086821234204980368L;

	/**
	 * RXgN^łB
	 * 
	 * @param pattern rΏۂ̃AhXp^[
	 */
	protected AddressStringTerm(final String pattern) {
		super(pattern, true); // we need case-insensitive comparison.
	}

	/**
	 * RXgN^Ŏw肳ꂽAhXp^[A
	 * Address IuWFNg̕\̕ł邩ǂ`FbN܂B<p>
	 * 
	 * w肳ꂽ Address IuWFNg̕\A
	 * Zbg͓]GR[fBO܂ޏꍇA
	 * ƍɃGR[fBOlȂ΂ȂȂɒӂĉB
	 * 
	 * @param a r Address IuWFNg
	 * @return ƍꍇ trueAłȂꍇ false
	 */
	protected final boolean match(final Address a) {
		if (a instanceof InternetAddress)
			// We dont use toString() to get "a"'s String representation,
			// because InternetAddress.toString() returns a RFC 2047 
			// encoded string, which isn't what we need here.
			return super.match(((InternetAddress)a).toUnicodeString());

		return super.match(a.toString());
	}

	/**
	 * rłB
	 */
	public boolean equals(final Object obj) {
		if (!(obj instanceof AddressStringTerm))
			return false;
		return super.equals(obj);
	}

}
