/*
 * Copyright 1997-2000 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail.search;

import javax.mail.Message;

/**
 * ̃NX́Aʂ SearchTerms ̘_ AND Zq܂B
 */
public final class AndTerm extends SearchTerm {

	private static final long serialVersionUID = -3583274505380989582L;

	/**
	 * AND ZqKpׂ̔złB
	 * 
	 * @serial
	 */
	protected SearchTerm[] terms;

	/**
	 * 2 ̏gpRXgN^łB
	 * 
	 * @param t1 ŏ̏
	 * @param t2 2 Ԗڂ̏
	 */
	public AndTerm(final SearchTerm t1, final SearchTerm t2) {
		terms = new SearchTerm[2];
		terms[0] = t1;
		terms[1] = t2;
	}

	/**
	 * SearchTerms ̔zgpRXgN^łB
	 * 
	 * @param t ̔z
	 */
	public AndTerm(final SearchTerm[] t) {
		terms = new SearchTerm[t.length]; // clone the array
		for (int i = 0; i < t.length; i++)
			terms[i] = t[i];
	}

	/**
	 * Ԃ܂B
	 */
	public SearchTerm[] getTerms() {
		return (SearchTerm[]) terms.clone();
	}

	/**
	 * AND ZłB<p>
	 * 
	 * RXgN^Ŏw肳͎w肳ꂽIuWFNgɓKpA
	 * AND Zq̌ʂɓKp܂B
	 * 
	 * @param msg w肳ꂽ SearchTerms  Message ɓKpAAND Zq̌ʂɓKp܂B
	 * @return AND ꍇ trueAłȂꍇ false
	 */
	public boolean match(final Message msg) {
		for (int i=0; i < terms.length; i++)
			if (!terms[i].match(msg))
				return false;
		return true;
	}

	/**
	 * rłB
	 */
	public boolean equals(final Object obj) {
		if (!(obj instanceof AndTerm))
			return false;
		AndTerm at = (AndTerm) obj;
		if (at.terms.length != terms.length)
			return false;
		for (int i=0; i < terms.length; i++)
			if (!terms[i].equals(at.terms[i]))
				return false;
		return true;
	}

	/**
	 * ̃IuWFNg̃nbVR[hvZ܂B
	 */
	public int hashCode() {
		int hash = 0;
		for (int i=0; i < terms.length; i++)
			hash += terms[i].hashCode();
		return hash;
	}

}
