/*
 * Copyright 1997-2003 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail.search;

import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Part;

/**
 * ̃NX́AMessage Body ̌܂B
 * {͎̌̏ꍇɂs܂B
 * (1) vC}^Cv Text łPꕔbZ[WA
 *  (2) ŏ̖{̃vC}^Cv Text ł镡/bZ[WB
 * ̏ꍇA͍ŏ̖{Ŏs܂B
 */
public final class BodyTerm extends StringTerm {

	private static final long serialVersionUID = -4888862527916911385L;

	/**
	 * RXgN^łB
	 * 
	 * @param pattern  String
	 */
	public BodyTerm(final String pattern) {
		// Note: comparison is case-insensitive
		super(pattern);
	}

	/**
	 * ƍ\bhłB
	 * 
	 * @param msg p^[͂ Message ̖{ɓKp
	 * @return p^[ꍇ trueAłȂꍇ false 
	 */
	public boolean match(final Message msg) {
		return matchPart(msg);
	}

	/**
	 * Search all the parts of the message for any text part
	 * that matches the pattern.
	 */
	private boolean matchPart(final Part p) {
		try {
			/*
			 * Using isMimeType to determine the content type avoids
			 * fetching the actual content data until we need it.
			 */
			if (p.isMimeType("text/*")) {
				String s = (String) p.getContent();
				if (s == null)
					return false;
				/*
				 * We invoke our superclass' (i.e., StringTerm) match method.
				 * Note however that StringTerm.match() is not optimized 
				 * for substring searches in large string buffers. We really
				 * need to have a StringTerm subclass, say BigStringTerm, 
				 * with its own match() method that uses a better algorithm ..
				 * and then subclass BodyTerm from BigStringTerm.
				 */ 
				return super.match(s);
			}
			if (p.isMimeType("multipart/*")) {
				Multipart mp = (Multipart) p.getContent();
				int count = mp.getCount();
				for (int i = 0; i < count; i++)
					if (matchPart(mp.getBodyPart(i)))
						return true;
			} else if (p.isMimeType("message/rfc822"))
				return matchPart((Part)p.getContent());
		} catch (Exception ex) {}
		return false;
	}

	/**
	 * rłB
	 */
	public boolean equals(final Object obj) {
		if (!(obj instanceof BodyTerm))
			return false;
		return super.equals(obj);
	}

}
