/*
 * Copyright 1997-2003 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail.search;

import java.util.Date;

/**
 * ̃NX Date ̔r܂B
 */
public abstract class DateTerm extends ComparisonTerm {

	private static final long serialVersionUID = 4818873430063720043L;

	/**
	 * tłB
	 * 
	 * @serial
	 */
	protected Date date;

	/**
	 * RXgN^łB
	 * 
	 * @param comparison r̃^Cv
	 * @param date rΏۂƂȂ Date
	 */
	protected DateTerm(final int comparison, final Date date) {
		this.comparison = comparison;
		this.date = date;
	}

	/**
	 * rΏۂ Date Ԃ܂B
	 */
	public final Date getDate() {
		return new Date(date.getTime());
	}

	/**
	 * r̃^CvԂ܂B
	 */
	public final int getComparison() {
		return comparison;
	}

	/**
	 * tr\bhłB
	 * 
	 * @param d RXgN^̓t̓tƔr
	 * @return tvꍇ trueAłȂꍇ false
	 */
	protected final boolean match(final Date d) {
		switch (comparison) {
			case LE: 
				return d.before(date) || d.equals(date);
			case LT:
				return d.before(date);
			case EQ:
				return d.equals(date);
			case NE:
				return !d.equals(date);
			case GT:
				return d.after(date);
			case GE:
				return d.after(date) || d.equals(date);
			default:
				return false;
		}
	}

	/**
	 * rłB
	 */
	public boolean equals(final Object obj) {
		if (!(obj instanceof DateTerm))
			return false;

		return ((DateTerm)obj).date.equals(date) && super.equals(obj);
	}

	/**
	 * ̃IuWFNg̃nbVR[hvZ܂B
	 */
	public int hashCode() {
		return date.hashCode() + super.hashCode();
	}

}
