/*
 * Copyright 1997-2000 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail.search;

import javax.mail.Flags;
import javax.mail.Message;

/**
 * ̃NX Message Flag ̔r܂B
 */
public final class FlagTerm extends SearchTerm {

	private static final long serialVersionUID = -142991500302030647L;

	/**
	 * w肳ꂽ Flag ̗L/ǂ炩𒲂ׂ邩ǂ܂B
	 * <code>true</code> ̏ꍇ͎w肳ꂽSẴtO݂鎖𒲂ׁA
	 * łȂꍇ͎w肳ꂽSẴtO݂ȂƂ𒲂ׂ܂B
	 * 
	 * @serial
	 */
	protected boolean set;

	/**
	 * tO܂ Flags IuWFNgłB
	 * 
	 * @serial
	 */
	protected Flags flags;

	/**
	 * RXgN^łB
	 * 
	 * @param flags tO܂ Flags IuWFNg
	 * @param set tOݒ
	 */
	public FlagTerm(final Flags flags, final boolean set) {
		this.flags = flags;
		this.set = set;
	}

	/**
	 *  Flag Ԃ܂B
	 */
	public Flags getFlags() {
		return (Flags) flags.clone();
	}

	/**
	 * tOݒ肳Ă鎖̌̏ꍇ true Ԃ܂B
	 */
	public boolean getTestSet() {
		return set;
	}

	/**
	 * r\bhłB
	 * 
	 * @param msg tOr͂ Message ɓKp
	 * @return rꍇ trueAłȂꍇ false
	 */
	public boolean match(final Message msg) {
		try {
			Flags f = msg.getFlags();
			if (set) { // This is easy
				if (f.contains(flags))
					return true;
				return false;
			}

			// Return true if ALL flags in the passed in Flags
			// object are NOT set in this Message.

			// Got to do this the hard way ...
			Flags.Flag[] sf = flags.getSystemFlags();

			// Check each flag in the passed in Flags object
			for (int i = 0; i < sf.length; i++) {
				if (f.contains(sf[i]))
					// this flag IS set in this Message, get out.
					return false;
			}

			String[] s = flags.getUserFlags();

			// Check each flag in the passed in Flags object
			for (int i = 0; i < s.length; i++) {
				if (f.contains(s[i]))
					// this flag IS set in this Message, get out.
					return false;
			}

			return true;
		} catch (Exception e) {
			return false;
		}
	}

	/**
	 * rłB
	 */
	public boolean equals(final Object obj) {
		if (!(obj instanceof FlagTerm))
			return false;

		FlagTerm ft = (FlagTerm) obj;
		return ft.set == set && ft.flags.equals(flags);
	}

	/**
	 * ̃IuWFNg̃nbVR[hvZ܂B
	 */
	public int hashCode() {
		return set ? flags.hashCode() : ~flags.hashCode();
	}

}
