/*
 * Copyright 1998-2003 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail.search;

import javax.mail.Message;
import javax.mail.Address;

/**
 * ̃NX From Address wb_̕r܂B<p>
 * 
 * ̃NX <code>FromTerm</code> NXƈقȂ鎖ɒӂĉB
 * ̃NX Address IuWFNgł͂ȂAAhXɂĔrs܂B
 * ̕r͑啶Əʂ܂B
 * 
 * @since JavaMail 1.1
 */
public final class FromStringTerm extends AddressStringTerm {

	private static final long serialVersionUID = 5801127523826772788L;

	/**
	 * RXgN^łB
	 * 
	 * @param pattern rΏۂ̃AhXp^[
	 */
	public FromStringTerm(final String pattern) {
		super(pattern);
	}

	/**
	 * RXgN^Ŏw肳ꂽAhX񂪁A
	 *  Message  From AhX̕ł邩ǂ`FbN܂B
	 * 
	 * @param msg r͂ Message  From AhXɓKp
	 * @return ƍꍇ trueAłȂꍇ false
	 */
	public boolean match(final Message msg) {
		Address[] from;

		try {
			from = msg.getFrom();
		} catch (Exception e) {
			return false;
		}

		if (from == null)
			return false;

		for (int i=0; i < from.length; i++)
			if (super.match(from[i]))
				return true;

		return false;
	}

	/**
	 * rłB
	 */
	public boolean equals(final Object obj) {
		if (!(obj instanceof FromStringTerm))
			return false;
		return super.equals(obj);
	}

}
