/*
 * Copyright 1997-2000 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail.search;

import javax.mail.Message;

/**
 * ̃NX Message wb_̔r܂B
 * ̔r͑啶Əʂ܂B
 */
public final class HeaderTerm extends StringTerm {

	private static final long serialVersionUID = 8342514650333389122L;

	/**
	 * wb_̖OłB
	 * 
	 * @serial
	 */
	protected String headerName;

	/**
	 * RXgN^łB
	 * 
	 * @param headerName wb_̖O
	 * @param pattern p^[
	 */
	public HeaderTerm(final String headerName, final String pattern) {
		super(pattern);
		this.headerName = headerName;
	}

	/**
	 * rwb_̖OԂ܂B
	 */
	public String getHeaderName() {
		return headerName;
	}

	/**
	 * wb_ƍ\bhłB
	 * 
	 * @param msg ƍ͂ Message ̃wb_ɓKp܂B
	 * @return ƍꍇ trueAłȂꍇ false
	 */
	public boolean match(final Message msg) {
		String[] headers;

		try {
			headers = msg.getHeader(headerName);
		} catch (Exception e) {
			return false;
		}

		if (headers == null)
			return false;

		for (int i=0; i < headers.length; i++)
			if (super.match(headers[i]))
				return true;

		return false;
	}

	/**
	 * rłB
	 */
	public boolean equals(final Object obj) {
		if (!(obj instanceof HeaderTerm))
			return false;
		HeaderTerm ht = (HeaderTerm) obj;
		// XXX - depends on header comparisons being case independent
		return ht.headerName.equalsIgnoreCase(headerName) && super.equals(ht);
	}

	/**
	 * ̃IuWFNg̃nbVR[hvZ܂B
	 */
	public int hashCode() {
		// XXX - depends on header comparisons being case independent
		return headerName.toLowerCase().hashCode() + super.hashCode();
	}

}
