/*
 * Copyright 1997-2000 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail.search;

/**
 * ̃NX͐̔r܂B
 */
public abstract class IntegerComparisonTerm extends ComparisonTerm {

	private static final long serialVersionUID = -6963571240154302484L;

	/**
	 * lłB
	 * 
	 * @serial
	 */
	protected int number;

	/**
	 * RXgN^łB
	 */
	protected IntegerComparisonTerm(final int comparison, final int number) {
		this.comparison = comparison;
		this.number = number;
	}

	/**
	 * r鐔lԂ܂B
	 */
	public final int getNumber() {
		return number;
	}

	/**
	 * r̃^CvԂ܂B
	 */
	public final int getComparison() {
		return comparison;
	}

	/**
	 * ƍ\bhłB
	 */
	protected final boolean match(final int i) {
		switch (comparison) {
			case LE: 
				return i <= number;
			case LT:
				return i < number;
			case EQ:
				return i == number;
			case NE:
				return i != number;
			case GT:
				return i > number;
			case GE:
				return i >= number;
			default:
				return false;
		}
	}

	/**
	 * rłB
	 */
	public boolean equals(final Object obj) {
		if (!(obj instanceof IntegerComparisonTerm))
			return false;
		IntegerComparisonTerm ict = (IntegerComparisonTerm) obj;
		return ict.number == number && super.equals(obj);
	}

	/**
	 * ̃IuWFNg̃nbVR[hvZ܂B
	 */
	public int hashCode() {
		return number + super.hashCode();
	}

}
