/*
 * Copyright 1997-2000 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail.search;

import javax.mail.Message;

/**
 * ̍ڂ RFC822 "MessageId" f܂B
 * ́AbZ[WɈӂƂȂC^[lbgbZ[W̃bZ[W ID łB
 * NCAg͂̍ڂgpA MessageId bZ[W̃tH_ł܂B<p>
 * 
 * MessageId  String ŕ\܂B
 */
public final class MessageIDTerm extends StringTerm {

	private static final long serialVersionUID = -2121096296454691963L;

	/**
	 * RXgN^łB
	 * 
	 * @param msgid 郁bZ[W ID
	 */
	public MessageIDTerm(final String msgid) {
		// Note: comparison is case-insensitive
		super(msgid);
	}

	/**
	 * ƍ\bhłB
	 * 
	 * @param msg ƍ͂ Message  Message-ID wb_ɓKp܂B 
	 * @return ƍꍇ trueAłȂꍇ false
	 */
	public boolean match(final Message msg) {
		String[] s;

		try {
			s = msg.getHeader("Message-ID");
		} catch (Exception e) {
			return false;
		}

		if (s == null)
			return false;

		for (int i=0; i < s.length; i++)
			if (super.match(s[i]))
				return true;

		return false;
	}

	/**
	 * rłB
	 */
	public boolean equals(final Object obj) {
		if (!(obj instanceof MessageIDTerm))
			return false;
		return super.equals(obj);
	}

}
