/*
 * Copyright 1997-2000 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail.search;

import javax.mail.Message;

/**
 * ̃NX Message ̔r܂B
 */
public final class MessageNumberTerm extends IntegerComparisonTerm {

	private static final long serialVersionUID = -5379625829658623812L;

	/**
	 * RXgN^łB
	 * 
	 * @param number Message 
	 */
	public MessageNumberTerm(final int number) {
		super(EQ, number);
	}

	/**
	 * ƍ\bhłB
	 * 
	 * @param msg Message ͂ Message ƈv܂B
	 * @return ƍꍇ trueAłȂꍇ false
	 */
	public boolean match(final Message msg) {
		int msgno;

		try {
			msgno = msg.getMessageNumber();
		} catch (Exception e) {
			return false;
		}

		return super.match(msgno);
	}

	/**
	 * rłB
	 */
	public boolean equals(final Object obj) {
		if (!(obj instanceof MessageNumberTerm))
			return false;
		return super.equals(obj);
	}

}
