/*
 * Copyright 1997-2000 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail.search;

import javax.mail.Message;

/**
 * ̃NX͘_ے艉Zq܂B
 */
public final class NotTerm extends SearchTerm {

	private static final long serialVersionUID = 7152293214217310216L;

	/**
	 * ے肷錟łB
	 * 
	 * @serial
	 */
	protected SearchTerm term;

	/**
	 * RXgN^łB
	 */
	public NotTerm(final SearchTerm t) {
		term = t;
	}

	/**
	 * ے肷錟Ԃ܂B
	 */
	public SearchTerm getTerm() {
		return term;
	}

	/* The NOT operation */
	public boolean match(final Message msg) {
		return !term.match(msg);
	}

	/**
	 * rłB
	 */
	public boolean equals(final Object obj) {
		if (!(obj instanceof NotTerm))
			return false;

		return ((NotTerm)obj).term.equals(term);
	}

	/**
	 * ̃IuWFNg̃nbVR[hvZ܂B
	 */
	public int hashCode() {
		return term.hashCode() << 1;
	}

}
