/*
 * Copyright 1997-2003 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail.search;

import javax.mail.Message;

/**
 * ̃NX͌ʂ SearchTerms ̘_ OR Zq܂B
 */
public final class OrTerm extends SearchTerm {

	private static final long serialVersionUID = 5380534067523646936L;

	/**
	 * OR ZqKpׂ̔złB
	 * 
	 * @serial
	 */
	protected SearchTerm[] terms;

	/**
	 * 2 ̃IyhgpRXgN^łB
	 * 
	 * @param t1 ŏ̏
	 * @param t2 2 Ԗڂ̏
	 */
	public OrTerm(final SearchTerm t1, final SearchTerm t2) {
		terms = new SearchTerm[2];
		terms[0] = t1;
		terms[1] = t2;
	}

	/**
	 * SearchTerms ̔zgpRXgN^łB
	 * 
	 * @param t 
	 */
	public OrTerm(final SearchTerm[] t) {
		terms = new SearchTerm[t.length];
		for (int i = 0; i < t.length; i++)
			terms[i] = t[i];
	}

	/**
	 * Ԃ܂B
	 */
	public SearchTerm[] getTerms() {
		return (SearchTerm[]) terms.clone();
	}

	/**
	 * OR ZłB<p>
	 * 
	 * RXgN^Ŏw肳͎w肳ꂽIuWFNgɓKpA
	 * OR Zq̌ʂɓKp܂B
	 * 
	 * @param msg w肳ꂽ SearchTerms  Message ɓKpAOR Zq̌ʂɓKp܂B
	 * @return OR ꍇ trueAłȂꍇ false
	 */
	public boolean match(final Message msg) {
		for (int i=0; i < terms.length; i++)
			if (terms[i].match(msg))
				return true;

		return false;
	}

	/**
	 * rłB
	 */
	public boolean equals(final Object obj) {
		if (!(obj instanceof OrTerm))
			return false;
		OrTerm ot = (OrTerm) obj;
		if (ot.terms.length != terms.length)
			return false;
		for (int i=0; i < terms.length; i++)
			if (!terms[i].equals(ot.terms[i]))
				return false;

		return true;
	}

	/**
	 * ̃IuWFNg̃nbVR[hvZ܂B
	 */
	public int hashCode() {
		int hash = 0;
		for (int i=0; i < terms.length; i++)
			hash += terms[i].hashCode();
		return hash;
	}

}
