/*
 * Copyright 1997-2000 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail.search;

import java.util.Date;
import javax.mail.Message;

/**
 * ̃NX Message Received t̔r܂B
 */
public final class ReceivedDateTerm extends DateTerm {

	private static final long serialVersionUID = -2756695246195503170L;

	/**
	 * RXgN^łB
	 * 
	 * @param comparison r̃^Cv
	 * @param date rt
	 */
	public ReceivedDateTerm(final int comparison, final Date date) {
		super(comparison, date);
	}

	/**
	 * ƍ\bhłB
	 * 
	 * @param msg trZq́A Message ̑MtɓKp܂B
	 * @return rꍇ trueAłȂꍇ false
	 */
	public boolean match(final Message msg) {
		Date d;

		try {
			d = msg.getReceivedDate();
		} catch (Exception e) {
			return false;
		}

		if (d == null)
			return false;

		return super.match(d);
	}

	/**
	 * rłB
	 */
	public boolean equals(final Object obj) {
		if (!(obj instanceof ReceivedDateTerm))
			return false;
		return super.equals(obj);
	}

}
