/*
 * Copyright 1998-2003 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail.search;

import javax.mail.Message;
import javax.mail.Address;

/**
 * ̃NX Recipient Address wb_̕r܂B<p>
 * 
 * ̃NX <code>RecipientTerm</code> NXƈقȂ鎖ɒӂĉB
 * ̃NX Address IuWFNgł͂ȂAAhXɂĔrs܂B
 * ̕r͑啶Əʂ܂B
 * 
 * @since JavaMail 1.1
 */
public final class RecipientStringTerm extends AddressStringTerm {

	private static final long serialVersionUID = -8293562089611618849L;

	/**
	 * M҂̌^
	 * 
	 * @serial
	 */
	private Message.RecipientType type;

	/**
	 * RXgN^łB
	 * 
	 * @param type M҂̌^
	 * @param pattern rAhXp^[
	 */
	public RecipientStringTerm(final Message.RecipientType type, final String pattern) {
		super(pattern);
		this.type = type;
	}

	/**
	 * ƍM҂̌^Ԃ܂B
	 */
	public Message.RecipientType getRecipientType() {
		return type;
	}

	/**
	 * RXgN^Ŏw肳ꂽAhXA
	 *  Message ̎M҃AhX̕ł邩ǂ`FbN܂B
	 * 
	 * @param msg r͂ Message ̎M҃AhXɓKp܂B
	 * @return ƍꍇ trueAłȂꍇ false
	 */
	public boolean match(final Message msg) {
		Address[] recipients;

		try {
			recipients = msg.getRecipients(type);
		} catch (Exception e) {
			return false;
		}

		if (recipients == null)
			return false;

		for (int i=0; i < recipients.length; i++)
			if (super.match(recipients[i]))
				return true;

		return false;
	}

	/**
	 * rłB
	 */
	public boolean equals(final Object obj) {
		if (!(obj instanceof RecipientStringTerm))
			return false;

		return ((RecipientStringTerm)obj).type.equals(type) && super.equals(obj);
	}

	/**
	 * ̃IuWFNg̃nbVR[hvZ܂B
	 */
	public int hashCode() {
		return type.hashCode() + super.hashCode();
	}

}
