/*
 * Copyright 1997-2000 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail.search;

import javax.mail.Message;
import javax.mail.Address;

/**
 * ̃NX Recipient Address wb_̔r܂B
 */
public final class RecipientTerm extends AddressTerm {

	private static final long serialVersionUID = 6548700653122680468L;

	/**
	 * M҂̌^łB
	 * 
	 * @serial
	 */
	protected Message.RecipientType type;

	/**
	 * RXgN^łB
	 * 
	 * @param type M҂̌^
	 * @param address ƍAhX
	 */
	public RecipientTerm(final Message.RecipientType type, final Address address) {
		super(address);
		this.type = type;
	}

	/**
	 * ƍM҂̌^Ԃ܂B
	 */
	public Message.RecipientType getRecipientType() {
		return type;
	}

	/**
	 * ƍ\bhłB
	 * 
	 * @param msg AhXƍ͂ Message ̎M҃AhXɓKp܂B
	 * @return ƍꍇ trueAłȂꍇ false
	 */
	public boolean match(final Message msg) {
		Address[] recipients;

		try {
			recipients = msg.getRecipients(type);
		} catch (Exception e) {
			return false;
		}

		if (recipients == null)
			return false;

		for (int i=0; i < recipients.length; i++)
			if (super.match(recipients[i]))
				return true;

		return false;
	}

	/**
	 * rłB
	 */
	public boolean equals(final Object obj) {
		if (!(obj instanceof RecipientTerm))
			return false;

		return ((RecipientTerm)obj).type.equals(type) && super.equals(obj);
	}

	/**
	 * ̃IuWFNg̃nbVR[hvZ܂B
	 */
	public int hashCode() {
		return type.hashCode() + super.hashCode();
	}

}
