/*
 * Copyright 1997-2000 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail.search;

import java.util.Date;
import javax.mail.Message;

/**
 * ̃NX Message SentDate ̔r܂B
 */
public final class SentDateTerm extends DateTerm {

	private static final long serialVersionUID = 5647755030530907263L;

	/**
	 * RXgN^łB
	 * 
	 * @param comparison ř^
	 * @param date rt
	 */
	public SentDateTerm(final int comparison, final Date date) {
		super(comparison, date);
	}

	/**
	 * ƍ\bhłB
	 * 
	 * @param msg trZq͂ Message ̑MtɓKp܂B
	 * @return rɐꍇ trueAłȂꍇ false
	 */
	public boolean match(final Message msg) {
		Date d;

		try {
			d = msg.getSentDate();
		} catch (Exception e) {
			return false;
		}

		if (d == null)
			return false;

		return super.match(d);
	}

	/**
	 * rłB
	 */
	public boolean equals(final Object obj) {
		if (!(obj instanceof SentDateTerm))
			return false;
		return super.equals(obj);
	}

}
