/*
 * Copyright 1997-2000 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail.search;

/**
 * ̃NX String ̏ƍ\bh܂B
 * ݂̎́ȀƍɂĂ̂ݒ񋟂܂B
 * rǉ邱Ƃł܂ (strcmp )B
 */
public abstract class StringTerm extends SearchTerm {

	private static final long serialVersionUID = 1274042129007696269L;

	/**
	 * p^[łB
	 * 
	 * @serial
	 */
	protected String pattern;

	/**
	 * rɑ啶Ə̋ʂ𖳎邩ǂw肵܂B
	 * 
	 * @serial
	 */
	protected boolean ignoreCase;

	/**
	 * RXgN^łA
	 */
	protected StringTerm(final String pattern) {
		this.pattern = pattern;
		ignoreCase = true;
	}

	/**
	 * RXgN^łA
	 */
	protected StringTerm(final String pattern, final boolean ignoreCase) {
		this.pattern = pattern;
		this.ignoreCase = ignoreCase;
	}

	/**
	 * ƍ镶Ԃ܂B
	 */
	public final String getPattern() {
		return pattern;
	}

	/**
	 * ƍɑ啶ƏʂȂ΂ȂȂꍇ́Atrue Ԃ܂B
	 */
	public final boolean getIgnoreCase() {
		return ignoreCase;
	}

	protected final boolean match(final String s) {
		int len = s.length() - pattern.length();
		for (int i=0; i <= len; i++)
			if (s.regionMatches(ignoreCase, i, pattern, 0, pattern.length()))
				return true;

		return false;
	}

	/**
	 * rłB
	 */
	public boolean equals(final Object obj) {
		if (!(obj instanceof StringTerm))
			return false;
		StringTerm st = (StringTerm) obj;
		if (ignoreCase)
			return st.pattern.equalsIgnoreCase(pattern) && st.ignoreCase == ignoreCase;
		return st.pattern.equals(pattern) && st.ignoreCase == ignoreCase;
	}

	/**
	 * ̃IuWFNg̃nbVR[hvZ܂B
	 */
	public int hashCode() {
		return ignoreCase ? pattern.hashCode() : ~pattern.hashCode();
	}

}
