/*
 * Copyright 1997-2000 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail.search;

import javax.mail.Message;

/**
 * ̃NX Message Subject wb_̔r܂B
 * ̔r͑啶Əʂ܂B
 */
public final class SubjectTerm extends StringTerm {

	private static final long serialVersionUID = 7481568618055573432L;

	/**
	 * RXgN^łB
	 * 
	 * @param pattern p^[
	 */
	public SubjectTerm(final String pattern) {
		// Note: comparison is case-insensitive
		super(pattern);
	}

	/**
	 * ƍ\bhłB
	 * 
	 * @param msg p^[ƍ͂ Message ̌wb_ɓKp܂B 
	 * @return p^[ƍɐꍇ trueAłȂꍇ false
	 */
	public boolean match(final Message msg) {
		String subj;

		try {
			subj = msg.getSubject();
		} catch (Exception e) {
			return false;
		}

		if (subj == null)
			return false;

		return super.match(subj);
	}

	/**
	 * rłB
	 */
	public boolean equals(final Object obj) {
		if (!(obj instanceof SubjectTerm))
			return false;
		return super.equals(obj);
	}

}
