/*
 * Copyright 1997-2000 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

import javax.mail.internet.SharedInputStream;

/**
 * SharedInputStream C^tF[X ByteArrayInputStream łB
 * {IȃoCgz񂪕̃[_ԂŋL̂܂B
 * 
 * @since JavaMail 1.4
 */
public final class SharedByteArrayInputStream extends ByteArrayInputStream implements SharedInputStream {

	/**
	 * Position within shared buffer that this stream starts at.
	 */
	protected int start = 0;

	/**
	 * Create a SharedByteArrayInputStream representing the entire byte array.
	 * 
	 * @param buf the byte array
	 */
	public SharedByteArrayInputStream(final byte[] buf) {
		super(buf);
	}

	/**
	 * Create a SharedByteArrayInputStream representing the part of the byte array from offset for length bytes.
	 * 
	 * @param buf the byte array
	 * @param offset offset in byte array to first byte to include
	 * @param length number of bytes to include
	 */
	public SharedByteArrayInputStream(final byte[] buf, final int offset, final int length) {
		super(buf, offset, length);
		start = offset;
	}

	/**
	 * Return the current position in the InputStream, as an offset from the beginning of the InputStream.
	 */
	public long getPosition() {
		return pos - start;
	}

	/**
	 * Return a new InputStream representing a subset of the data from this InputStream,
	 * starting at start (inclusive) up to end (exclusive).
	 * start must be non-negative.
	 * If end is -1, the new stream ends at the same place as this stream.
	 * The returned InputStream will also implement the SharedInputStream interface.
	 */
	public InputStream newStream(final long start, long end) {
		if (start < 0)
			throw new IllegalArgumentException("start < 0");
		if (end == -1)
			end = count - this.start;
		return new SharedByteArrayInputStream(buf, this.start + (int)start, (int)(end - start));
	}

}
