/*
 * Copyright (C) 2003-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.mail.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

import javax.activation.DataSource;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;

/**
 * Cӂ̃oCif[^yуeLXgf[^\ DataSource łB
 * charset p^ɑΉĂ܂B
 * 
 * @author V _
 * @deprecated  javax.mail.util.ByteArrayDataSource gpĉB
 */
public final class ByteArrayDataSource implements DataSource {

	private byte[] data;
	private String contentType;

	/**
	 * oCif[^̃f[^\[X𐶐RXgN^łB
	 * 
	 * @param data oCif[^
	 * @param contentType Rec^Cv
	 */
	public ByteArrayDataSource(final byte[] data, final String contentType) {
		this.data = data;
		this.contentType = contentType;
	}

	/**
	 * oCif[^̃f[^\[X𐶐RXgN^łB
	 * 
	 * @param in ̓Xg[
	 * @param contentType Rec^Cv
	 * @throws IOException o͗Oꍇ
	 */
	public ByteArrayDataSource(InputStream in, String contentType) throws IOException {
		this.contentType = contentType;
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		byte[] buf = new byte[2048];
		int len;
		
		while ((len = in.read(buf)) != -1) {
			out.write(buf, 0, len);
		}
		data = out.toByteArray();
	}

	/**
	 * Xg[ text/* p̃f[^\[X𐶐RXgN^łB
	 * contentType  charset p[^ɉăGR[hꂽf[^𐶐܂B
	 * charset p[^́AReader Ɏ{ꂽGR[fBOƓw肳Ȃ΂Ȃ܂B
	 * 
	 * @param in 
	 * @param contentType Rec^Cv
	 * @throws IOException o͗Oꍇ
	 */
	public ByteArrayDataSource(final Reader in, final String contentType) throws IOException {
		this.contentType = contentType;
		String charset = null;
		try {
			ContentType ct = new ContentType(contentType);
			charset = ct.getParameter("charset");
		} catch (ParseException e) {}	// 

		if (charset == null)
			charset = "us-ascii";

		BufferedReader reader = new BufferedReader(in);
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		String line;

		while ((line = reader.readLine()) != null) {
			out.write(line.getBytes(charset));
			out.write('\r');
			out.write('\n');
		}
		data = out.toByteArray();
	}

	/**
	 * Xg[ text/* p̃f[^\[X𐶐RXgN^łB
	 * contentType  charset p[^ɉăGR[hꂽf[^𐶐܂B
	 * 
	 * @param text eLXg
	 * @param contentType Rec^Cv
	 */
	public ByteArrayDataSource(String text, String contentType) {
		this.contentType = contentType;
		String charset = null;

		try {
			ContentType ct = new ContentType(contentType);
			charset = ct.getParameter("charset");
		} catch (ParseException e) {}	// 

		if (charset == null)
			charset = "us-ascii";

		try {
			data = text.getBytes(charset);
		} catch (UnsupportedEncodingException e) {
			try {
				data = text.getBytes("us-ascii");
			} catch (UnsupportedEncodingException uee) {}	// 
		}
	}

	/**
	 * @see javax.activation.DataSource#getContentType()
	 */
	public String getContentType() {
		return contentType;
	}

	/**
	 * @see javax.activation.DataSource#getInputStream()
	 */
	public InputStream getInputStream() throws IOException {
		if (data == null)
			throw new IOException("no data");

		return new ByteArrayInputStream(data);
	}

	/**
	 * ̎ł͕K <code>null</code> Ԃ܂B
	 * 
	 * @see javax.activation.DataSource#getName()
	 */
	public String getName() {
		return null;
	}

	/**
	 * @see javax.activation.DataSource#getOutputStream()
	 */
	public OutputStream getOutputStream() throws IOException {
		throw new IOException("cannot do this");
	}

}
