/*
 * Copyright (C) 2003-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.mail.util;

import java.io.UnsupportedEncodingException;

/**
 * ̃NX́AJIS (ISO-2022-JP)AVtgJIS (Windows-31J)AEUC-JP ̎ʂs@\񋟂܂B
 * 
 * @author V _
 */
public final class JISAutoDetect {

	/**
	 * CX^XłȂ܂B
	 */
	private JISAutoDetect() {}

	/**
	 * w肳ꂽ񂩂{ꕶR[hʂ Unicode ֕ϊ(fR[h)܂B
	 * 
	 * @param str 
	 * @return Unicode ֕ϊꂽ
	 */
	public static String decode(final String str) {
		try {
			return decode(str.getBytes("8859_1"));
		} catch (UnsupportedEncodingException e) {
			return str;
		}
	}

	/**
	 * w肳ꂽoCg񂩂{ꕶR[hʂ Unicode ֕ϊ(fR[h)܂B
	 * 
	 * @param bytes oCgz
	 * @return Unicode ֕ϊꂽ
	 * @throws UnsupportedEncodingException
	 */
	public static String decode(final byte[] bytes) throws UnsupportedEncodingException {
		// w肳ꂽoCg񒆂 ESC R[h JIS Ɣf܂B
		for (int i = 0; i < bytes.length; i++) {
			if (bytes[i] == (byte)'\u001B') {
				return WindowsJIS.decode(bytes);
			}
		}

        // EUC-JP ŃfR[hėOꍇ́AVtgJIS Ƃ݂Ȃ܂B
        try {
            return WindowsEUCJP.decode(bytes);
        } catch (UnsupportedEncodingException e) {
			// ȊȌꍇ́AVtgJISƂ݂Ȃ܂
			return new String(bytes, "Windows-31J");
        }
	}

}
