/*
 * Copyright (C) 2003-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.mail.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

import javax.mail.MessagingException;
import javax.mail.internet.MimeUtility;

/**
 * @author V _
 */
public final class MailUtils {

	/**
	 * wb_̕fR[h܂B
	 * MimeUtility ̐ɂ߂ē{ŗʂGR[h`ɑΉB
	 * 
	 * @param etext
	 */
	public static final String decodeText(final String etext) {
		if (etext == null) return null;

		// JIS R[hGR[hŋLqđMĂ郁[΍
		// ESC R[h̗Lɂ萶 JIS ǂ؂܂B
		// A{[_zGS`UFȂlɂ܂B
		if (etext.indexOf('\u001b') > -1) {
			// ISO-2022-JP
			try {
				// Java W JIS Ro[^ł͋KiO̕ҒʂɕϊĂȂ̂ŁAƎRo[^gp܂B
				return WindowsJIS.decode(etext.getBytes("ISO-8859-1"));
			} catch (UnsupportedEncodingException e) {
				throw new InternalError();
			}
		}

		return new RFC2047Decoder(etext).get();
	}

	/**
	 * wʒuŏɌLWSPȊO̕IndexԂ܂B
	 * startIndex ͈͊Ȍꍇ -1 Ԃ܂B
	 * (IndexOutOfBoundsException ł͂Ȃ)
	 * @param source 镶
	 * @param startIndex Jnʒu
	 * @param decrease trueŌ
	 * @return oASCIIIndexBȂ-1B
	 */
	private static final int indexOfNonLWSP(final String source, final int startIndex, final boolean decrease) {
		char c;
		int inc = 1;
		if (decrease) inc = -1;

		for (int index = startIndex; index >= 0 && index < source.length(); index += inc) {
			c = source.charAt(index);
			if (!isLWSP(c)) {
				return index;
			}
		}
		return -1;
	}

	/**
	 * wʒuŏɌLWSPIndexԂ܂B
	 * startIndex ͈͊Ȍꍇ -1 Ԃ܂B
	 * (IndexOutOfBoundsException ł͂Ȃ)
	 * @param source 镶
	 * @param startIndex Jnʒu
	 * @param decrease trueŌ
	 * @param additionalDelimiter LWSPȊOɋ؂Ƃ݂Ȃ(1̂)
	 * @return oASCIIIndexBȂ-1B
	 */
	private static final int indexOfLWSP(
		final String source,
		final int startIndex,
		final boolean decrease,
		final char additionalDelimiter) {

		char c;
		int inc = 1;
		if (decrease) inc = -1;

		for (int index = startIndex; index >= 0 && index < source.length(); index += inc) {
			c = source.charAt(index);
			if (isLWSP(c) || c == additionalDelimiter) {
				return index;
			}
		}
		return -1;
	}

	private static final boolean isLWSP(final char c) {
		return (c == '\r' || c == '\n' || c == ' ' || c == '\t');
	}

//	{fR[hŖ肪̂ŁAencoded-word̐؂oׂ͂ēƎ
//	NetscapeȂǂ"()."̕encoded-word؂Ă܂AJavaMail
//	̂Ƃencoded-word̏I𔻒łAꕔ̕Ă܂B
//	܂Aencoded-word 𕶎fR[ĥxAאڂ encoded-word
//	 CES ꍇ́A TES fR[hsoCgĂ
//	CES ɏ]fR[hsB}`oCg𕪒f sender 邩B
	 static class RFC2047Decoder {
		 private String source;
		 private String pooledCES;
		 private byte[] pooledBytes;
		 private StringBuffer buf;

		 private int pos = 0;
		 private int startIndex;
		 private int endIndex;

		 public RFC2047Decoder(final String source) {
			 this.source = source;
			 buf = new StringBuffer(source.length());
			 parse();
		 }

		 private void parse() {
			 //String tes;
			 while (hasEncodedWord()) {
				 String work = source.substring(pos, startIndex);
				 if (indexOfNonLWSP(work, 0, false) > -1) {
					 sweepPooledBytes();
					 buf.append(work);
				 } // encoded-wordm̊ԂLWSP͍폜

				 parseWord();
			 }
			 sweepPooledBytes();

             if (pos == 0)
                // GR[hw肪Ȃꍇ͐JISSJISȂǂ̔s܂
             	buf.append(JISAutoDetect.decode(source));
             else
             	buf.append(source.substring(pos));
		 }

		 // encoded-word ꍇAstartIndex/endIndex Zbg
		 private boolean hasEncodedWord() {
			 startIndex = source.indexOf("=?", pos);
			 if (startIndex == -1)
                return false;
			 endIndex = source.indexOf("?=", startIndex + 2);
			 if (endIndex == -1)
                return false;

			 int i = indexOfLWSP(source, startIndex + 2, false, (char)0);
//			 if (i >= 0 && i < endIndex) return false;
			 endIndex += 2;
			 return true;
		 }

		 private void parseWord() {
			 try {
				 int s = startIndex + 2;
				 int e = source.indexOf('?', s);
				 if (e == endIndex - 2) throw new RuntimeException();
				 String ces = source.substring(s, e);
				 if (ces.equalsIgnoreCase("UNKNOWN") || ces.equalsIgnoreCase("SHIFT_JIS"))
				 	ces = "Windows-31J";

				 // Java WfR[_ɑ݂ȂR[ȟn̏ꍇ͈ȉ̏ubNs܂
				 if (!"UTF-7".equalsIgnoreCase(ces))
				 	"".getBytes(ces); // FIXME: check whether supported or not

				 s = e + 1;
				 e = source.indexOf('?', s);
				 if (e == endIndex - 2)
				 	throw new RuntimeException();
				 String tes = source.substring(s, e);

				 byte[] bytes = decodeByTES(source.substring(e + 1, endIndex - 2), tes);
				 if (ces.equals(pooledCES)) {
					 // append bytes
					 byte[] w = new byte[pooledBytes.length + bytes.length];
					 System.arraycopy(pooledBytes, 0, w, 0,pooledBytes.length);
					 System.arraycopy(bytes, 0, w, pooledBytes.length,bytes.length);
					 pooledBytes = w;
				 } else {
					 sweepPooledBytes();
					 pooledCES = ces;
					 pooledBytes = bytes;
				 }
			 } catch (Exception ex) {
				 // contains RuntimeException
				 buf.append(source.substring(startIndex, endIndex));
			 }
			 pos = endIndex;
		 }

		private void sweepPooledBytes() {
			if (pooledBytes == null)
				return;

			try {
				if ("ISO-2022-JP".equalsIgnoreCase(pooledCES))
					buf.append(WindowsJIS.decode(pooledBytes));
				else if ("euc-jp".equalsIgnoreCase(pooledCES))
					buf.append(WindowsEUCJP.decode(pooledBytes));
				else if ("utf-7".equalsIgnoreCase(pooledCES)) {
					try {
						buf.append(UTF7.decode(pooledBytes));
					} catch (IOException e) {
						buf.append(new String(pooledBytes, "ISO-8859-1"));
					}
				} else
					buf.append(new String(pooledBytes, pooledCES));
			} catch (IOException e) {
				throw new InternalError("CANT HAPPEN: Illegal encoding = " + pooledCES);
			}
			pooledCES = null;
			pooledBytes = null;
		}

		 public String get() {
			 return new String(buf);
		 }
	 }

	private static byte[] decodeByTES(String s, String tes) throws MessagingException {
		try {
			ByteArrayInputStream bis = new ByteArrayInputStream(com.sun.mail.util.ASCIIUtility.getBytes(s));

			InputStream is;
			if (tes.equalsIgnoreCase("B"))
				is = new com.sun.mail.util.BASE64DecoderStream(bis);
			else if (tes.equalsIgnoreCase("Q"))
				is = new com.sun.mail.util.QDecoderStream(bis);
			else
				throw new UnsupportedEncodingException(tes);

			int count = bis.available();
			byte[] bytes = new byte[count];
			try {
				 count = is.read(bytes, 0, count);
			} catch (IOException e) {
				ByteArrayInputStream sStream = new ByteArrayInputStream(s.getBytes());
				InputStream sDecodeStream = MimeUtility.decode(sStream, "base64");
				bytes = new byte[sDecodeStream.available()];
				sDecodeStream.read(bytes, 0, bytes.length);
				return bytes;
			}

			if (count != bytes.length) {
				byte[] w = new byte[count];
				System.arraycopy(bytes, 0, w, 0, count);
				bytes = w;
			}
			return bytes;
		} catch (IOException e) {
			throw new RuntimeException("CANT HAPPEN");
		}
	}

}
