/*
 * Copyright (c) 2003-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.mail.util;

import java.io.IOException;

/**
 * UTF-7 p[eBeBNXłB
 * 
 * @author V _
 */
public final class UTF7 {

	/**
	 * UTF7  Unicode ֕ϊ(fR[h)܂B
	 * 
	 * @param input UTF7 R[hŕ\ꂽoCgz
	 * @return Unicode ֕ϊꂽ
	 * @throws IOException
	 */
	public static String decode(final byte[] input) throws IOException {
		return decode(input, input.length);
	}

	/**
	 * UTF7  Unicode ֕ϊ(fR[h)܂B
	 * 
	 * @param bytes UTF7 R[hŕ\ꂽoCgz
	 * @param length input ̏錅
	 * @return Unicode ֕ϊꂽ
	 * @throws IOException
	 */
	public static String decode(final byte[] bytes, final int length) throws IOException {
		ByteToCharUTF7 btc = new ByteToCharUTF7();
		char[] chars = new char[bytes.length / 2 + 1];
		btc.convert(bytes, 0, bytes.length, chars, 0, chars.length);
		return new String(chars);
	}

}
