/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.mail.internet.HeaderTokenizer;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;

public final class ParameterList {
    private Map list = new LinkedHashMap();
    private static boolean encodeParameters = false;
    private static boolean decodeParameters = false;
    private static boolean decodeParametersStrict = false;
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    static {
        try {
            String s = System.getProperty("mail.mime.encodeparameters");
            encodeParameters = s != null && s.equalsIgnoreCase("true");
            s = System.getProperty("mail.mime.decodeparameters");
            decodeParameters = s != null && s.equalsIgnoreCase("true");
            s = System.getProperty("mail.mime.decodeparameters.strict");
            decodeParametersStrict = s != null && s.equalsIgnoreCase("true");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public ParameterList() {
    }

    public ParameterList(String s) throws ParseException {
        HeaderTokenizer.Token tk;
        HeaderTokenizer h = new HeaderTokenizer(s, "()<>@,;:\\\"\t []/?=");
        while (true) {
            int type;
            if ((type = (tk = h.next()).getType()) == -4) {
                return;
            }
            if ((char)type != ';') break;
            tk = h.next();
            if (tk.getType() == -4) {
                return;
            }
            if (tk.getType() != -1) {
                throw new ParseException("Expected parameter name, got \"" + tk.getValue() + "\"");
            }
            String name = tk.getValue().toLowerCase();
            tk = h.next();
            if ((char)tk.getType() != '=') {
                throw new ParseException("Expected '=', got \"" + tk.getValue() + "\"");
            }
            tk = h.next();
            int type2 = tk.getType();
            if (type2 != -1 && type2 != -2) {
                throw new ParseException("Expected parameter value, got \"" + tk.getValue() + "\"");
            }
            String value = tk.getValue();
            if (decodeParameters && name.endsWith("*")) {
                name = name.substring(0, name.length() - 1);
                this.list.put(name, this.decodeValue(value));
                continue;
            }
            this.list.put(name, value);
        }
        throw new ParseException("Expected ';', got \"" + tk.getValue() + "\"");
    }

    public int size() {
        return this.list.size();
    }

    public String get(String name) {
        Object obj = this.list.get(name.trim().toLowerCase());
        if (obj instanceof Value) {
            return ((Value)obj).value;
        }
        return (String)obj;
    }

    public void set(String name, String value) {
        this.list.put(name.trim().toLowerCase(), value);
    }

    public void set(String name, String value, String charset) {
        if (encodeParameters) {
            Value v = this.encodeValue(value, charset);
            if (v != null) {
                this.list.put(name.trim().toLowerCase(), v);
            } else {
                this.set(name, value);
            }
        } else {
            this.set(name, value);
        }
    }

    public void remove(String name) {
        this.list.remove(name.trim().toLowerCase());
    }

    public Enumeration getNames() {
        return new ParamEnum(this.list.keySet().iterator());
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int used) {
        StringBuffer sb = new StringBuffer();
        Iterator iterator = this.list.keySet().iterator();
        while (iterator.hasNext()) {
            String value;
            String name = (String)iterator.next();
            Object obj = this.list.get(name);
            if (obj instanceof Value) {
                value = ((Value)obj).encodedValue;
                name = String.valueOf(name) + '*';
            } else {
                value = (String)obj;
            }
            value = this.quote(value);
            sb.append("; ");
            int len = name.length() + value.length() + 1;
            if ((used += 2) + len > 76) {
                sb.append("\r\n\t");
                used = 8;
            }
            sb.append(name).append('=');
            if ((used += name.length() + 1) + value.length() > 76) {
                String s = MimeUtility.fold(used, value);
                sb.append(s);
                int lastlf = s.lastIndexOf(10);
                if (lastlf >= 0) {
                    used += s.length() - lastlf - 1;
                    continue;
                }
                used += s.length();
                continue;
            }
            sb.append(value);
            used += value.length();
        }
        return sb.toString();
    }

    private String quote(String value) {
        return MimeUtility.quote(value, "()<>@,;:\\\"\t []/?=");
    }

    private Value encodeValue(String s, String s1) {
        byte[] bytes;
        if (MimeUtility.checkAscii(s) == 1) {
            return null;
        }
        try {
            bytes = s.getBytes(MimeUtility.javaCharset(s1));
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
        StringBuffer sb = new StringBuffer(bytes.length + s1.length() + 2);
        sb.append(s1).append("''");
        int i = 0;
        while (i < bytes.length) {
            char c = (char)(bytes[i] & 0xFF);
            if (c <= ' ' || c >= '\u007f' || c == '*' || c == '\'' || c == '%' || "()<>@,;:\\\"\t []/?=".indexOf(c) >= 0) {
                sb.append('%').append(hex[c >> 4]).append(hex[c & 0xF]);
            } else {
                sb.append(c);
            }
            ++i;
        }
        Value value = new Value();
        value.value = s;
        value.encodedValue = sb.toString();
        return value;
    }

    private Value decodeValue(String s) throws ParseException {
        Value value;
        block12: {
            value = new Value();
            value.encodedValue = s;
            value.value = s;
            try {
                int i = s.indexOf(39);
                if (i <= 0) {
                    if (decodeParametersStrict) {
                        throw new ParseException("Missing charset in encoded value: " + s);
                    }
                    return value;
                }
                String s1 = s.substring(0, i);
                int j = s.indexOf(39, i + 1);
                if (j < 0) {
                    if (decodeParametersStrict) {
                        throw new ParseException("Missing language in encoded value: " + s);
                    }
                    return value;
                }
                s.substring(i + 1, j);
                s = s.substring(j + 1);
                byte[] bytes = new byte[s.length()];
                i = 0;
                int k = 0;
                while (i < s.length()) {
                    char c = s.charAt(i);
                    if (c == '%') {
                        String s3 = s.substring(i + 1, i + 3);
                        c = (char)Integer.parseInt(s3, 16);
                        i += 2;
                    }
                    bytes[k++] = (byte)c;
                    ++i;
                }
                value.value = new String(bytes, 0, k, MimeUtility.javaCharset(s1));
            }
            catch (NumberFormatException nfex) {
                if (decodeParametersStrict) {
                    throw new ParseException(nfex.toString());
                }
            }
            catch (UnsupportedEncodingException ueex) {
                if (decodeParametersStrict) {
                    throw new ParseException(ueex.toString());
                }
            }
            catch (StringIndexOutOfBoundsException sioobex) {
                if (!decodeParametersStrict) break block12;
                throw new ParseException(sioobex.toString());
            }
        }
        return value;
    }

    private static class ParamEnum
    implements Enumeration {
        private Iterator it;

        ParamEnum(Iterator iterator) {
            this.it = iterator;
        }

        public boolean hasMoreElements() {
            return this.it.hasNext();
        }

        public Object nextElement() {
            return this.it.next();
        }
    }

    private static class Value {
        String value;
        String encodedValue;

        Value() {
        }
    }
}

