/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.search;

import javax.mail.Message;
import javax.mail.search.StringTerm;

public final class HeaderTerm
extends StringTerm {
    private static final long serialVersionUID = 8342514650333389122L;
    protected String headerName;

    public HeaderTerm(String headerName, String pattern) {
        super(pattern);
        this.headerName = headerName;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public boolean match(Message msg) {
        String[] headers;
        try {
            headers = msg.getHeader(this.headerName);
        }
        catch (Exception e) {
            return false;
        }
        if (headers == null) {
            return false;
        }
        int i = 0;
        while (i < headers.length) {
            if (super.match(headers[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HeaderTerm)) {
            return false;
        }
        HeaderTerm ht = (HeaderTerm)obj;
        return ht.headerName.equalsIgnoreCase(this.headerName) && super.equals(ht);
    }

    public int hashCode() {
        return this.headerName.toLowerCase().hashCode() + super.hashCode();
    }
}

