/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.lang;

public final class Ascii {
    public static final char NUL = '\u0000';
    public static final char SOH = '\u0001';
    public static final char STX = '\u0002';
    public static final char ETX = '\u0003';
    public static final char EOT = '\u0004';
    public static final char ENQ = '\u0005';
    public static final char ACK = '\u0006';
    public static final char BEL = '\u0007';
    public static final char BS = '\b';
    public static final char HT = '\t';
    public static final char TAB = '\t';
    public static final char LF = '\n';
    public static final char NL = '\n';
    public static final char EOL = '\n';
    public static final char VT = '\u000b';
    public static final char FF = '\f';
    public static final char CR = '\r';
    public static final char SO = '\u000e';
    public static final char SI = '\u000f';
    public static final char DLE = '\u0010';
    public static final char DC1 = '\u0011';
    public static final char DC2 = '\u0012';
    public static final char DC3 = '\u0013';
    public static final char DC4 = '\u0014';
    public static final char NAK = '\u0015';
    public static final char SYN = '\u0016';
    public static final char ETB = '\u0017';
    public static final char CAN = '\u0018';
    public static final char EM = '\u0019';
    public static final char SUB = '\u001a';
    public static final char ESC = '\u001b';
    public static final char FS = '\u001c';
    public static final char GS = '\u001d';
    public static final char RS = '\u001e';
    public static final char US = '\u001f';
    public static final char SP = ' ';
    public static final char DEL = '\u007f';
    public static final String CRLF = "\r\n";

    private Ascii() {
    }

    public static boolean isControlCharacter(char c) {
        return c < ' ' || c == '\u007f';
    }

    public static String removeControlCharacters(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder results = new StringBuilder(s.length());
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (!Ascii.isControlCharacter(c)) {
                results.append(c);
            }
            ++i;
        }
        return results.toString();
    }
}

