/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.mail;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Enumeration;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import jp.sourceforge.livez.lang.JaStringUtils;
import jp.sourceforge.livez.lang.VodafoneEmojiUtils;
import jp.sourceforge.livez.mail.EmojiType;
import jp.sourceforge.livez.mail.MailMessage;
import jp.sourceforge.livez.mail.MailUtils;
import jp.sourceforge.livez.mail.util.ByteArrayDataSource;
import jp.sourceforge.livez.mail.util.EZwebJIS;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

final class MailMessageImpl
implements MailMessage {
    protected MimeMessage message = null;
    private EmojiType emojiType = EmojiType.IMODE;

    public MailMessageImpl(MimeMessage message) {
        this.message = message;
    }

    public MimeMessage getMimeMessage() {
        return this.message;
    }

    public void setEmojiType(EmojiType type) {
        this.emojiType = type;
    }

    public EmojiType getEmojiType() {
        return this.emojiType;
    }

    public Enumeration getAllHeaders() {
        try {
            return this.message.getAllHeaders();
        }
        catch (MessagingException e) {
            return null;
        }
    }

    public String[] getHeader(String name) {
        try {
            return this.message.getHeader(name);
        }
        catch (MessagingException e) {
            return new String[0];
        }
    }

    public String getHeader(String name, String delimiter) {
        try {
            return this.message.getHeader(name, delimiter);
        }
        catch (MessagingException e) {
            return "";
        }
    }

    public int getSize() {
        try {
            return this.message.getSize();
        }
        catch (MessagingException e) {
            return -1;
        }
    }

    public String getMessageId() {
        try {
            return this.message.getMessageID();
        }
        catch (MessagingException e) {
            return "";
        }
    }

    public Flags getFlags() {
        try {
            return this.message.getFlags();
        }
        catch (MessagingException e) {
            return null;
        }
    }

    public boolean isSet(Flags.Flag flag) {
        try {
            return this.message.isSet(flag);
        }
        catch (MessagingException e) {
            return false;
        }
    }

    public int getPriority() {
        int result = 3;
        try {
            result = NumberUtils.toInt((String)this.message.getHeader("X-Priority", null));
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        if (result <= 0) {
            result = 3;
        }
        return result;
    }

    public String getMailerName() {
        String mailer;
        try {
            mailer = StringUtils.defaultString((String)this.message.getHeader("X-Mailer", null));
            if (mailer.length() <= 0) {
                mailer = StringUtils.defaultString((String)this.message.getHeader("User-Agent", null));
            }
        }
        catch (MessagingException e) {
            return "";
        }
        return mailer;
    }

    public Address[] getReplyTo() {
        try {
            return this.incorrectIcons(this.message.getReplyTo());
        }
        catch (MessagingException e) {
            return null;
        }
    }

    public Address[] getFrom() {
        try {
            return this.incorrectIcons(this.message.getFrom());
        }
        catch (MessagingException e) {
            return null;
        }
    }

    public Address[] getTo() {
        try {
            return this.incorrectIcons(this.message.getRecipients(Message.RecipientType.TO));
        }
        catch (MessagingException e) {
            return null;
        }
    }

    public Address[] getCc() {
        try {
            return this.incorrectIcons(this.message.getRecipients(Message.RecipientType.CC));
        }
        catch (MessagingException e) {
            return null;
        }
    }

    public Address[] getAllRecipients() {
        try {
            return this.incorrectIcons(this.message.getAllRecipients());
        }
        catch (MessagingException e) {
            return null;
        }
    }

    public String getSubject() {
        try {
            return StringUtils.defaultString((String)this.incorrectIcons(this.message.getSubject()));
        }
        catch (MessagingException e) {
            return "";
        }
    }

    public Date getSentDate() {
        try {
            Date date = this.message.getSentDate();
            if (date == null) {
                date = this.message.getReceivedDate();
            }
            if (date == null) {
                return new Date(0L);
            }
            return date;
        }
        catch (MessagingException e) {
            return new Date(0L);
        }
    }

    public String getText() {
        String text = "";
        try {
            text = StringUtils.defaultString((String)MailUtils.getFirstPlainText((Part)this.message));
        }
        catch (MessagingException messagingException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.incorrectIcons(text);
    }

    public boolean isHtml() {
        try {
            if (this.message.isMimeType("text/html")) {
                return true;
            }
            if (this.message.isMimeType("multipart/*")) {
                Multipart mp = (Multipart)this.message.getContent();
                int index = 0;
                while (index < mp.getCount()) {
                    if (mp.getBodyPart(index).isMimeType("text/html")) {
                        return true;
                    }
                    ++index;
                }
            }
        }
        catch (MessagingException messagingException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public boolean isHtmlOnly() {
        return this.isHtmlOnly(true);
    }

    public boolean isHtmlOnly(boolean trim) {
        if (!this.isHtml()) {
            return false;
        }
        try {
            String text = MailUtils.getFirstPlainText((Part)this.message);
            if (text != null && trim) {
                text = JaStringUtils.trim(text);
            }
            return StringUtils.isEmpty((String)text);
        }
        catch (MessagingException messagingException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public String getHtml() {
        try {
            if (this.message.isMimeType("text/html")) {
                return (String)this.message.getContent();
            }
            if (this.message.isMimeType("multipart/*")) {
                Multipart mp = (Multipart)this.message.getContent();
                int index = 0;
                while (index < mp.getCount()) {
                    BodyPart part = mp.getBodyPart(index);
                    if (part.isMimeType("text/html")) {
                        return (String)mp.getBodyPart(index).getContent();
                    }
                    ++index;
                }
            }
        }
        catch (MessagingException messagingException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "";
    }

    public boolean isMimeType(int number, String type) {
        int count = -1;
        try {
            if (this.message.isMimeType("multipart/*")) {
                Multipart mp = (Multipart)this.message.getContent();
                int index = 0;
                while (index < mp.getCount()) {
                    BodyPart part = mp.getBodyPart(index);
                    if (!part.isMimeType("text/plain") && !part.isMimeType("text/html") && !part.isMimeType("multipart/*") && (part.isMimeType("message/rfc822") ? ++count == number && part.isMimeType(type) : part.getFileName() != null && ++count == number && part.isMimeType(type))) {
                        return true;
                    }
                    ++index;
                }
            }
        }
        catch (MessagingException messagingException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public Object getFile(int number) {
        int count = -1;
        try {
            if (!this.message.isMimeType("text/plain") && !this.message.isMimeType("text/html")) {
                if (this.message.isMimeType("multipart/*")) {
                    Multipart mp = (Multipart)this.message.getContent();
                    int index = 0;
                    while (index < mp.getCount()) {
                        BodyPart part = mp.getBodyPart(index);
                        if (!(part.isMimeType("text/plain") || part.isMimeType("text/html") || part.isMimeType("multipart/*"))) {
                            if (part.isMimeType("message/rfc822")) {
                                MailMessageImpl msg = new MailMessageImpl((MimeMessage)part.getContent());
                                if (++count == number) {
                                    return msg;
                                }
                            } else if (part.getFileName() != null && ++count == number) {
                                return part.getInputStream();
                            }
                        }
                        ++index;
                    }
                } else if (this.message.getFileName() != null && ++count == number) {
                    return this.message.getInputStream();
                }
            }
        }
        catch (MessagingException messagingException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public void addTo(String name, String address) throws MessagingException {
        this.addRecipient(Message.RecipientType.TO, name, address);
    }

    public void addCc(String name, String address) throws MessagingException {
        this.addRecipient(Message.RecipientType.CC, name, address);
    }

    public void addBcc(String name, String address) throws MessagingException {
        this.addRecipient(Message.RecipientType.BCC, name, address);
    }

    private void addRecipient(Message.RecipientType type, String name, String address) throws MessagingException {
        InternetAddress[] ia = new InternetAddress[]{MailUtils.createInternetAddress(StringUtils.defaultString((String)address).trim(), StringUtils.defaultString((String)this.correctIcons(name)).trim())};
        this.message.addRecipients(type, (Address[])ia);
    }

    public void setSubject(String subject) throws MessagingException {
        try {
            this.message.setSubject(MimeUtility.encodeText((String)this.correctIcons(subject), (String)"ISO-2022-JP", (String)"B"));
        }
        catch (UnsupportedEncodingException e) {
            throw new MessagingException();
        }
    }

    public void setText(String text) throws MessagingException {
        this.message.setText(this.correctIcons(text), "ISO-2022-JP");
    }

    public void setHtml(String text, String html) throws MessagingException {
        MimeBodyPart textPart = new MimeBodyPart();
        MimeBodyPart htmlPart = new MimeBodyPart();
        textPart.setText(this.correctIcons(text), "ISO-2022-JP");
        htmlPart.setText(this.correctIcons(html), "ISO-2022-JP");
        htmlPart.setHeader("Content-Type", "text/html");
        MimeMultipart mp = new MimeMultipart("alternative");
        mp.addBodyPart((BodyPart)textPart);
        mp.addBodyPart((BodyPart)htmlPart);
        this.message.setContent((Multipart)mp);
    }

    public void attachFile(String filename, byte[] data, String contentType) throws IOException, MessagingException {
        MimeMultipart mp;
        MimeBodyPart part;
        String type = contentType == null || contentType.length() <= 0 ? "application/octet-stream" : contentType;
        if (this.message.getContent() == null) {
            part = new MimeBodyPart();
            part.setText("", "ISO-2022-JP");
            mp = new MimeMultipart();
            mp.addBodyPart((BodyPart)part);
        } else if (this.message.getContent() instanceof String) {
            String text = (String)this.message.getContent();
            MimeBodyPart part2 = new MimeBodyPart();
            part2.setText(text, "ISO-2022-JP");
            mp = new MimeMultipart();
            mp.addBodyPart((BodyPart)part2);
        } else {
            mp = (MimeMultipart)this.message.getContent();
        }
        part = new MimeBodyPart();
        ByteArrayDataSource ds = new ByteArrayDataSource(data, type);
        part.setDataHandler(new DataHandler((DataSource)ds));
        part.setFileName(MimeUtility.encodeText((String)filename, (String)"ISO-2022-JP", (String)"B"));
        mp.addBodyPart((BodyPart)part);
        this.message.setContent((Multipart)mp);
    }

    public void setFlag(Flags.Flag flag, boolean set) throws MessagingException {
        this.message.setFlag(flag, set);
    }

    public void setHeader(String name, String value) throws MessagingException {
        this.message.setHeader(name, value);
    }

    private String correctIcons(String text) {
        if (this.emojiType == EmojiType.EZWEB) {
            return EZwebJIS.correct((String)text);
        }
        if (this.emojiType == EmojiType.VODAFONE) {
            return VodafoneEmojiUtils.escapeWebCode456(text);
        }
        return text;
    }

    private String incorrectIcons(String text) {
        if (this.emojiType == EmojiType.EZWEB) {
            return EZwebJIS.incorrect((String)text);
        }
        return text;
    }

    private Address[] incorrectIcons(Address[] addresses) {
        if (addresses == null) {
            return new Address[0];
        }
        if (this.emojiType == EmojiType.EZWEB) {
            InternetAddress[] ia = new InternetAddress[addresses.length];
            int index = 0;
            while (index < addresses.length) {
                InternetAddress addr = (InternetAddress)addresses[index];
                try {
                    ia[index] = new InternetAddress(addr.getAddress(), this.incorrectIcons(addr.getPersonal()), "ISO-2022-JP");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                ++index;
            }
            return ia;
        }
        return addresses;
    }
}

