/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.pages;

import jp.sourceforge.livez.lang.StringEscapeUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.AttributesImpl;

abstract class AbstractPageHandler
extends DefaultHandler2 {
    protected StringBuilder page = new StringBuilder(2048);
    private boolean seenBody = false;
    private boolean seenPlainText = false;
    private boolean seenXmp = false;

    AbstractPageHandler() {
    }

    public final String getPage() {
        return this.page.toString();
    }

    public void startDocument() throws SAXException {
        this.seenBody = false;
    }

    public void endDocument() throws SAXException {
        this.seenBody = false;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("body") && !this.seenBody) {
            this.seenBody = true;
        } else if (!this.seenBody) {
            return;
        }
        if ("body".equalsIgnoreCase(qName)) {
            AttributesImpl attrs = new AttributesImpl(attributes);
            if (attrs.getValue("text") == null) {
                attrs.addAttribute("", "", "text", "CDATA", "black");
            }
            if (attrs.getValue("link") == null) {
                attrs.addAttribute("", "", "link", "CDATA", "blue");
            }
            if (attrs.getValue("alink") == null) {
                attrs.addAttribute("", "", "alink", "CDATA", "red");
            }
            if (attrs.getValue("vlink") == null) {
                attrs.addAttribute("", "", "vlink", "CDATA", "purple");
            }
            if (attrs.getValue("bgcolor") == null) {
                attrs.addAttribute("", "", "bgcolor", "CDATA", "white");
            }
            this.doStart(uri, localName, qName, attrs);
        } else if ("plaintext".equalsIgnoreCase(qName)) {
            this.seenPlainText = true;
            this.doStart(uri, localName, qName, attributes);
        } else if ("xmp".equalsIgnoreCase(qName)) {
            this.seenXmp = true;
            this.doStart(uri, localName, qName, attributes);
        } else {
            this.doStart(uri, localName, qName, attributes);
        }
    }

    protected void doStart(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.page.append('<');
        this.page.append(qName);
        int i = 0;
        while (i < attributes.getLength()) {
            this.page.append(' ');
            this.page.append(attributes.getQName(i));
            this.page.append('=');
            this.page.append('\"');
            this.page.append(attributes.getValue(i));
            this.page.append('\"');
            ++i;
        }
        this.page.append('>');
    }

    public final void endElement(String uri, String localName, String qName) throws SAXException {
        if (!this.seenBody) {
            return;
        }
        this.doEnd(uri, localName, qName);
        if ("body".equalsIgnoreCase(qName)) {
            this.seenBody = false;
            this.seenPlainText = false;
        } else if ("xmp".equalsIgnoreCase(qName)) {
            this.seenXmp = false;
        }
    }

    protected void doEnd(String uri, String localName, String qName) throws SAXException {
        if (!AbstractPageHandler.isSimpleElement(qName)) {
            this.page.append('<');
            this.page.append('/');
            this.page.append(qName);
            this.page.append('>');
        }
    }

    protected static final boolean isSimpleElement(String tagname) {
        return "meta".equalsIgnoreCase(tagname) || "base".equalsIgnoreCase(tagname) || "br".equalsIgnoreCase(tagname) || "hr".equalsIgnoreCase(tagname) || "img".equalsIgnoreCase(tagname) || "input".equalsIgnoreCase(tagname) || "embed".equalsIgnoreCase(tagname) || "isindex".equalsIgnoreCase(tagname) || "nextid".equalsIgnoreCase(tagname) || "spacer".equalsIgnoreCase(tagname) || "wbr".equalsIgnoreCase(tagname) || "plaintext".equalsIgnoreCase(tagname);
    }

    public final void characters(char[] ch, int start, int length) {
        if (!this.seenBody) {
            return;
        }
        String text = new String(ch, start, length);
        if (this.seenPlainText || this.seenXmp) {
            this.page.append(text);
        } else {
            this.page.append(StringEscapeUtils.escapeHtml(text));
        }
    }

    public final void comment(char[] ch, int start, int length) {
        if (!this.seenBody) {
            return;
        }
        String comment = "<!--" + new String(ch, start, length) + "-->";
        this.page.append(comment);
    }
}

