/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.pages;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import jp.sourceforge.livez.pages.FramePageHandler;
import jp.sourceforge.livez.pages.HTMLParser;
import org.apache.commons.io.IOUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class FramePageConverter {
    private FramePageConverter() {
    }

    public static String convert(byte[] bytes, String encoding) throws IOException, SAXException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try {
            String string = FramePageConverter.convert(in, encoding);
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    private static String convert(InputStream in, String encoding) throws IOException, SAXException {
        InputSource input = new InputSource(in);
        if (encoding != null) {
            input.setEncoding(encoding);
        }
        return FramePageConverter.convert(input);
    }

    private static String convert(InputSource input) throws IOException, SAXException {
        FramePageHandler handler = new FramePageHandler();
        HTMLParser.parse(input, handler, null);
        return handler.getPage();
    }
}

