/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.pages;

import java.net.URI;
import java.net.URISyntaxException;
import jp.sourceforge.livez.pages.HTMLOverview;
import jp.sourceforge.livez.pages.HTMLType;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ext.DefaultHandler2;

final class HTMLAnalyzerHandler
extends DefaultHandler2 {
    private HTMLOverview overview = new HTMLOverview();
    private boolean seenTitle;

    HTMLAnalyzerHandler() {
    }

    public HTMLOverview getOverview() {
        return this.overview;
    }

    public void startDocument() {
        this.overview = new HTMLOverview();
        this.seenTitle = false;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (qName.equalsIgnoreCase("title") && StringUtils.isEmpty((String)this.overview.getTitle())) {
            this.seenTitle = true;
        } else if (qName.equalsIgnoreCase("base") && this.overview.getBaseURI() == null) {
            try {
                this.overview.setBaseURI(new URI(attributes.getValue("href")));
            }
            catch (URISyntaxException uRISyntaxException) {}
        } else if (qName.equalsIgnoreCase("body") && this.overview.getType() == null) {
            this.overview.setType(HTMLType.CONTENTS);
        } else if (qName.equalsIgnoreCase("frameset") && this.overview.getType() == null) {
            this.overview.setType(HTMLType.FRAMESET);
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.seenTitle) {
            this.overview.setTitle(new String(ch, start, length));
            this.seenTitle = false;
        }
    }
}

