/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.pages;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import jp.sourceforge.livez.pages.BlockLevelHandler;
import jp.sourceforge.livez.pages.ElementFilter;
import jp.sourceforge.livez.pages.FrameSetConverter;
import jp.sourceforge.livez.pages.HTMLAnalyzer;
import jp.sourceforge.livez.pages.HTMLOverview;
import jp.sourceforge.livez.pages.HTMLParser;
import jp.sourceforge.livez.pages.HTMLType;
import jp.sourceforge.livez.util.URLUtils;
import org.apache.commons.io.IOUtils;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class PageConverter {
    public static String toMobile(File file, String encoding) throws MalformedURLException, IOException, SAXException {
        return PageConverter.toMobile(file.toURI().toURL(), encoding);
    }

    public static String toMobile(URL url, String encoding) throws IOException, SAXException {
        URLConnection conn = URLUtils.getURLConnection(url);
        conn.connect();
        byte[] bytes = URLUtils.getByteArray(conn);
        String charset = URLUtils.getCharSet(conn);
        HTMLOverview header = HTMLAnalyzer.analyze(bytes, charset);
        if (header.getType() == null) {
            return "<html><body></body></html>";
        }
        StringBuilder page = new StringBuilder(2048);
        page.append("<html>");
        page.append(header.render());
        if (header.getType() == HTMLType.FRAMESET) {
            bytes = FrameSetConverter.convert(bytes, charset, url, header).getBytes(encoding);
        }
        page.append(PageConverter.convert(bytes, encoding));
        page.append("</html>");
        return page.toString();
    }

    private static String convert(byte[] bytes, String encoding) throws IOException, SAXException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try {
            String string = PageConverter.convert(in, encoding);
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    private static String convert(InputStream in, String encoding) throws IOException, SAXException {
        InputSource input = new InputSource(in);
        if (encoding != null) {
            input.setEncoding(encoding);
        }
        return PageConverter.convert(input);
    }

    private static String convert(InputSource input) throws IOException, SAXException {
        BlockLevelHandler handler = new BlockLevelHandler();
        HTMLParser.parse(input, handler, new XMLDocumentFilter[]{new ElementFilter()});
        return handler.getPage();
    }
}

