/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.io.IOUtils;

public final class URLUtils {
    private URLUtils() {
    }

    public static final String decode(String s) throws IllegalArgumentException {
        if (s == null) {
            return null;
        }
        URLCodec codec = new URLCodec();
        try {
            return codec.decode(s, "Windows-31J");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static final String encode(String s) {
        if (s == null) {
            return null;
        }
        URLCodec codec = new URLCodec();
        try {
            return codec.encode(s, "Windows-31J");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static URLConnection getURLConnection(URL url) throws IOException {
        URLConnection con = url.openConnection();
        con.setConnectTimeout(30000);
        con.setReadTimeout(30000);
        con.setDoInput(true);
        con.setDoOutput(false);
        con.setUseCaches(false);
        return con;
    }

    public static byte[] getByteArray(URL url) throws IOException {
        return URLUtils.getByteArray(URLUtils.getURLConnection(url));
    }

    public static byte[] getByteArray(URLConnection con) throws IOException {
        InputStream in = con.getInputStream();
        try {
            byte[] byArray = IOUtils.toByteArray((InputStream)in);
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public static String getCharSet(URLConnection con) {
        String type = con.getContentType();
        if (type == null) {
            return null;
        }
        int i = type.lastIndexOf("charset=");
        if (i == -1) {
            return null;
        }
        String charset = type.substring(i + "charset=".length());
        if ("Shift_JIS".equalsIgnoreCase(charset) || "SJIS".equalsIgnoreCase(charset)) {
            return "Windows-31J";
        }
        return charset;
    }
}

