/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.builder.xml;

import com.ibatis.common.exception.NestedRuntimeException;
import com.ibatis.common.resources.Resources;
import com.ibatis.common.xml.Nodelet;
import com.ibatis.common.xml.NodeletParser;
import com.ibatis.common.xml.NodeletUtils;
import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.client.extensions.TypeHandlerCallback;
import com.ibatis.sqlmap.engine.accessplan.AccessPlanFactory;
import com.ibatis.sqlmap.engine.builder.xml.BaseParser;
import com.ibatis.sqlmap.engine.builder.xml.SqlMapClasspathEntityResolver;
import com.ibatis.sqlmap.engine.builder.xml.SqlMapParser;
import com.ibatis.sqlmap.engine.builder.xml.XmlConverter;
import com.ibatis.sqlmap.engine.cache.CacheModel;
import com.ibatis.sqlmap.engine.datasource.DataSourceFactory;
import com.ibatis.sqlmap.engine.impl.SqlMapClientImpl;
import com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import com.ibatis.sqlmap.engine.transaction.TransactionConfig;
import com.ibatis.sqlmap.engine.transaction.TransactionManager;
import com.ibatis.sqlmap.engine.type.CustomTypeHandler;
import com.ibatis.sqlmap.engine.type.TypeHandler;
import com.ibatis.sqlmap.engine.type.TypeHandlerFactory;
import java.io.Reader;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;

public class SqlMapConfigParser
extends BaseParser {
    private final NodeletParser parser = new NodeletParser();
    static /* synthetic */ Class class$com$ibatis$sqlmap$engine$transaction$jdbc$JdbcTransactionConfig;
    static /* synthetic */ Class class$com$ibatis$sqlmap$engine$transaction$jta$JtaTransactionConfig;
    static /* synthetic */ Class class$com$ibatis$sqlmap$engine$transaction$external$ExternalTransactionConfig;
    static /* synthetic */ Class class$com$ibatis$sqlmap$engine$datasource$SimpleDataSourceFactory;
    static /* synthetic */ Class class$com$ibatis$sqlmap$engine$datasource$DbcpDataSourceFactory;
    static /* synthetic */ Class class$com$ibatis$sqlmap$engine$datasource$JndiDataSourceFactory;
    static /* synthetic */ Class class$com$ibatis$sqlmap$engine$cache$fifo$FifoCacheController;
    static /* synthetic */ Class class$com$ibatis$sqlmap$engine$cache$lru$LruCacheController;
    static /* synthetic */ Class class$com$ibatis$sqlmap$engine$cache$memory$MemoryCacheController;
    static /* synthetic */ Class class$com$ibatis$sqlmap$engine$type$DomTypeMarker;
    static /* synthetic */ Class class$com$ibatis$sqlmap$engine$type$DomCollectionTypeMarker;
    static /* synthetic */ Class class$com$ibatis$sqlmap$engine$type$XmlTypeMarker;
    static /* synthetic */ Class class$com$ibatis$sqlmap$engine$type$XmlCollectionTypeMarker;

    public SqlMapConfigParser() {
        this(null, null);
    }

    public SqlMapConfigParser(XmlConverter sqlMapConfigConv, XmlConverter sqlMapConv) {
        super(new BaseParser.Variables());
        this.parser.setValidation(true);
        this.parser.setEntityResolver((EntityResolver)new SqlMapClasspathEntityResolver());
        this.vars.sqlMapConfigConv = sqlMapConfigConv;
        this.vars.sqlMapConv = sqlMapConv;
        this.vars.delegate = new SqlMapExecutorDelegate();
        this.vars.typeHandlerFactory = this.vars.delegate.getTypeHandlerFactory();
        this.vars.client = new SqlMapClientImpl(this.vars.delegate);
        this.registerDefaultTypeAliases();
        this.addSqlMapConfigNodelets();
        this.addGlobalPropNodelets();
        this.addSettingsNodelets();
        this.addTypeAliasNodelets();
        this.addTypeHandlerNodelets();
        this.addTransactionManagerNodelets();
        this.addSqlMapNodelets();
    }

    public SqlMapClient parse(Reader reader, Properties props) {
        this.vars.properties = props;
        return this.parse(reader);
    }

    public SqlMapClient parse(Reader reader) {
        try {
            if (this.vars.sqlMapConfigConv != null) {
                reader = this.vars.sqlMapConfigConv.convertXml(reader);
            }
            this.parser.parse(reader);
            return this.vars.client;
        }
        catch (Exception e) {
            throw new NestedRuntimeException("Error occurred.  Cause: " + e, (Throwable)e);
        }
    }

    private void addSqlMapConfigNodelets() {
        this.parser.addNodelet("/sqlMapConfig/end()", new Nodelet(){

            public void process(Node node) throws Exception {
                Iterator cacheNames = SqlMapConfigParser.this.vars.client.getDelegate().getCacheModelNames();
                while (cacheNames.hasNext()) {
                    String cacheName = (String)cacheNames.next();
                    CacheModel cacheModel = SqlMapConfigParser.this.vars.client.getDelegate().getCacheModel(cacheName);
                    Iterator statementNames = cacheModel.getFlushTriggerStatementNames();
                    while (statementNames.hasNext()) {
                        String statementName = (String)statementNames.next();
                        MappedStatement statement = SqlMapConfigParser.this.vars.client.getDelegate().getMappedStatement(statementName);
                        if (statement != null) {
                            statement.addExecuteListener(cacheModel);
                            continue;
                        }
                        throw new NestedRuntimeException("Could not find statement named '" + statementName + "' for use as a flush trigger for the cache model named '" + cacheName + "'.");
                    }
                }
            }
        });
    }

    private void addGlobalPropNodelets() {
        this.parser.addNodelet("/sqlMapConfig/properties", new Nodelet(){

            public void process(Node node) throws Exception {
                SqlMapConfigParser.this.vars.errorCtx.setActivity("loading global properties");
                Properties attributes = NodeletUtils.parseAttributes((Node)node, (Properties)SqlMapConfigParser.this.vars.properties);
                String resource = attributes.getProperty("resource");
                String url = attributes.getProperty("url");
                try {
                    Properties props = null;
                    if (resource != null) {
                        SqlMapConfigParser.this.vars.errorCtx.setResource(resource);
                        props = Resources.getResourceAsProperties((String)resource);
                    } else if (url != null) {
                        SqlMapConfigParser.this.vars.errorCtx.setResource(url);
                        props = Resources.getUrlAsProperties((String)url);
                    } else {
                        throw new NestedRuntimeException("The properties element requires either a resource or a url attribute.");
                    }
                    if (SqlMapConfigParser.this.vars.properties == null) {
                        SqlMapConfigParser.this.vars.properties = props;
                    } else {
                        props.putAll((Map<?, ?>)SqlMapConfigParser.this.vars.properties);
                        SqlMapConfigParser.this.vars.properties = props;
                    }
                }
                catch (Exception e) {
                    throw new NestedRuntimeException("Error loading properties.  Cause: " + e);
                }
            }
        });
    }

    private void addSettingsNodelets() {
        this.parser.addNodelet("/sqlMapConfig/settings", new Nodelet(){

            public void process(Node node) throws Exception {
                String maxSessions;
                String maxRequests;
                SqlMapConfigParser.this.vars.errorCtx.setActivity("loading settings properties");
                Properties attributes = NodeletUtils.parseAttributes((Node)node, (Properties)SqlMapConfigParser.this.vars.properties);
                String lazyLoadingEnabledAttr = attributes.getProperty("lazyLoadingEnabled");
                boolean lazyLoadingEnabled = lazyLoadingEnabledAttr == null || "true".equals(lazyLoadingEnabledAttr);
                SqlMapConfigParser.this.vars.client.getDelegate().setLazyLoadingEnabled(lazyLoadingEnabled);
                String cacheModelsEnabledAttr = attributes.getProperty("cacheModelsEnabled");
                boolean cacheModelsEnabled = cacheModelsEnabledAttr == null || "true".equals(cacheModelsEnabledAttr);
                SqlMapConfigParser.this.vars.client.getDelegate().setCacheModelsEnabled(cacheModelsEnabled);
                String enhancementEnabledAttr = attributes.getProperty("enhancementEnabled");
                boolean enhancementEnabled = enhancementEnabledAttr == null || "true".equals(enhancementEnabledAttr);
                try {
                    enhancementEnabled = enhancementEnabled && Class.forName("net.sf.cglib.proxy.InvocationHandler") != null;
                }
                catch (ClassNotFoundException e) {
                    enhancementEnabled = false;
                }
                SqlMapConfigParser.this.vars.client.getDelegate().setEnhancementEnabled(enhancementEnabled);
                String useStatementNamespacesAttr = attributes.getProperty("useStatementNamespaces");
                SqlMapConfigParser.this.vars.useStatementNamespaces = "true".equals(useStatementNamespacesAttr);
                String maxTransactions = attributes.getProperty("maxTransactions");
                if (maxTransactions != null && Integer.parseInt(maxTransactions) > 0) {
                    SqlMapConfigParser.this.vars.client.getDelegate().setMaxTransactions(Integer.parseInt(maxTransactions));
                }
                if ((maxRequests = attributes.getProperty("maxRequests")) != null && Integer.parseInt(maxRequests) > 0) {
                    SqlMapConfigParser.this.vars.client.getDelegate().setMaxRequests(Integer.parseInt(maxRequests));
                }
                if ((maxSessions = attributes.getProperty("maxSessions")) != null && Integer.parseInt(maxSessions) > 0) {
                    SqlMapConfigParser.this.vars.client.getDelegate().setMaxSessions(Integer.parseInt(maxSessions));
                }
                AccessPlanFactory.setBytecodeEnhancementEnabled(SqlMapConfigParser.this.vars.client.getDelegate().isEnhancementEnabled());
            }
        });
    }

    private void addTypeAliasNodelets() {
        this.parser.addNodelet("/sqlMapConfig/typeAlias", new Nodelet(){

            public void process(Node node) throws Exception {
                Properties prop = NodeletUtils.parseAttributes((Node)node, (Properties)SqlMapConfigParser.this.vars.properties);
                String alias = prop.getProperty("alias");
                String type = prop.getProperty("type");
                SqlMapConfigParser.this.vars.typeHandlerFactory.putTypeAlias(alias, type);
            }
        });
    }

    private void addTypeHandlerNodelets() {
        this.parser.addNodelet("/sqlMapConfig/typeHandler", new Nodelet(){

            /*
             * WARNING - void declaration
             */
            public void process(Node node) throws Exception {
                SqlMapConfigParser.this.vars.errorCtx.setActivity("building a building custom type handler");
                try {
                    void var7_9;
                    TypeHandler typeHandler;
                    TypeHandlerFactory typeHandlerFactory = SqlMapConfigParser.this.vars.client.getDelegate().getTypeHandlerFactory();
                    Properties prop = NodeletUtils.parseAttributes((Node)node, (Properties)SqlMapConfigParser.this.vars.properties);
                    String jdbcType = prop.getProperty("jdbcType");
                    String javaType = prop.getProperty("javaType");
                    String callback = prop.getProperty("callback");
                    callback = typeHandlerFactory.resolveAlias(callback);
                    javaType = typeHandlerFactory.resolveAlias(javaType);
                    SqlMapConfigParser.this.vars.errorCtx.setMoreInfo("Check the callback attribute '" + callback + "' (must be a classname).");
                    Object impl = Resources.classForName((String)callback).newInstance();
                    if (impl instanceof TypeHandlerCallback) {
                        typeHandler = new CustomTypeHandler((TypeHandlerCallback)impl);
                    } else if (impl instanceof TypeHandler) {
                        typeHandler = (TypeHandler)impl;
                    } else {
                        throw new NestedRuntimeException("The class '' is not a valid implementation of TypeHandler or TypeHandlerCallback");
                    }
                    SqlMapConfigParser.this.vars.errorCtx.setMoreInfo("Check the javaType attribute '" + javaType + "' (must be a classname) or the jdbcType '" + jdbcType + "' (must be a JDBC type name).");
                    if (jdbcType != null && jdbcType.length() > 0) {
                        typeHandlerFactory.register(Resources.classForName((String)javaType), jdbcType, (TypeHandler)var7_9);
                    } else {
                        typeHandlerFactory.register(Resources.classForName((String)javaType), (TypeHandler)var7_9);
                    }
                }
                catch (Exception e) {
                    throw new SqlMapException("Error registering occurred.  Cause: " + e, e);
                }
                SqlMapConfigParser.this.vars.errorCtx.setMoreInfo(null);
                SqlMapConfigParser.this.vars.errorCtx.setObjectId(null);
            }
        });
    }

    private void addTransactionManagerNodelets() {
        this.parser.addNodelet("/sqlMapConfig/transactionManager/end()", new Nodelet(){

            public void process(Node node) throws Exception {
                SqlMapConfigParser.this.vars.errorCtx.setActivity("configuring the transaction manager");
                Properties attributes = NodeletUtils.parseAttributes((Node)node, (Properties)SqlMapConfigParser.this.vars.properties);
                String type = attributes.getProperty("type");
                type = SqlMapConfigParser.this.vars.typeHandlerFactory.resolveAlias(type);
                TransactionManager txManager = null;
                try {
                    SqlMapConfigParser.this.vars.errorCtx.setMoreInfo("Check the transaction manager type or class.");
                    TransactionConfig config = (TransactionConfig)Resources.instantiate((String)type);
                    config.setDataSource(SqlMapConfigParser.this.vars.dataSource);
                    config.setMaximumConcurrentTransactions(SqlMapConfigParser.this.vars.client.getDelegate().getMaxTransactions());
                    SqlMapConfigParser.this.vars.errorCtx.setMoreInfo("Check the transactio nmanager properties or configuration.");
                    config.initialize(SqlMapConfigParser.this.vars.txProps);
                    SqlMapConfigParser.this.vars.errorCtx.setMoreInfo(null);
                    txManager = new TransactionManager(config);
                    txManager.setForceCommit("true".equals(attributes.getProperty("commitRequired")));
                }
                catch (Exception e) {
                    if (e instanceof SqlMapException) {
                        throw (SqlMapException)((Object)e);
                    }
                    throw new SqlMapException("Error initializing TransactionManager.  Could not instantiate TransactionConfig.  Cause: " + e, e);
                }
                SqlMapConfigParser.this.vars.client.getDelegate().setTxManager(txManager);
            }
        });
        this.parser.addNodelet("/sqlMapConfig/transactionManager/property", new Nodelet(){

            public void process(Node node) throws Exception {
                Properties attributes = NodeletUtils.parseAttributes((Node)node, (Properties)SqlMapConfigParser.this.vars.properties);
                String name = attributes.getProperty("name");
                String value = NodeletUtils.parsePropertyTokens((String)attributes.getProperty("value"), (Properties)SqlMapConfigParser.this.vars.properties);
                SqlMapConfigParser.this.vars.txProps.setProperty(name, value);
            }
        });
        this.parser.addNodelet("/sqlMapConfig/transactionManager/dataSource", new Nodelet(){

            public void process(Node node) throws Exception {
                SqlMapConfigParser.this.vars.dsProps = new Properties();
            }
        });
        this.parser.addNodelet("/sqlMapConfig/transactionManager/dataSource/end()", new Nodelet(){

            public void process(Node node) throws Exception {
                SqlMapConfigParser.this.vars.errorCtx.setActivity("configuring the data source");
                Properties attributes = NodeletUtils.parseAttributes((Node)node, (Properties)SqlMapConfigParser.this.vars.properties);
                String type = attributes.getProperty("type");
                type = SqlMapConfigParser.this.vars.typeHandlerFactory.resolveAlias(type);
                try {
                    SqlMapConfigParser.this.vars.errorCtx.setMoreInfo("Check the data source type or class.");
                    DataSourceFactory dsFactory = (DataSourceFactory)Resources.instantiate((String)type);
                    SqlMapConfigParser.this.vars.errorCtx.setMoreInfo("Check the data source properties or configuration.");
                    dsFactory.initialize(SqlMapConfigParser.this.vars.dsProps);
                    SqlMapConfigParser.this.vars.dataSource = dsFactory.getDataSource();
                    SqlMapConfigParser.this.vars.errorCtx.setMoreInfo(null);
                }
                catch (Exception e) {
                    if (e instanceof SqlMapException) {
                        throw (SqlMapException)((Object)e);
                    }
                    throw new SqlMapException("Error initializing DataSource.  Could not instantiate DataSourceFactory.  Cause: " + e, e);
                }
            }
        });
        this.parser.addNodelet("/sqlMapConfig/transactionManager/dataSource/property", new Nodelet(){

            public void process(Node node) throws Exception {
                Properties attributes = NodeletUtils.parseAttributes((Node)node, (Properties)SqlMapConfigParser.this.vars.properties);
                String name = attributes.getProperty("name");
                String value = NodeletUtils.parsePropertyTokens((String)attributes.getProperty("value"), (Properties)SqlMapConfigParser.this.vars.properties);
                SqlMapConfigParser.this.vars.dsProps.setProperty(name, value);
            }
        });
    }

    private void addSqlMapNodelets() {
        this.parser.addNodelet("/sqlMapConfig/sqlMap", new Nodelet(){

            public void process(Node node) throws Exception {
                SqlMapConfigParser.this.vars.errorCtx.setActivity("loading the SQL Map resource");
                Properties attributes = NodeletUtils.parseAttributes((Node)node, (Properties)SqlMapConfigParser.this.vars.properties);
                String resource = attributes.getProperty("resource");
                String url = attributes.getProperty("url");
                Reader reader = null;
                if (resource != null) {
                    SqlMapConfigParser.this.vars.errorCtx.setResource(resource);
                    reader = Resources.getResourceAsReader((String)resource);
                } else if (url != null) {
                    SqlMapConfigParser.this.vars.errorCtx.setResource(url);
                    reader = Resources.getUrlAsReader((String)url);
                } else {
                    throw new SqlMapException("The sqlMap element requires either a resource or a url attribute.");
                }
                if (SqlMapConfigParser.this.vars.sqlMapConv != null) {
                    reader = SqlMapConfigParser.this.vars.sqlMapConv.convertXml(reader);
                }
                new SqlMapParser(SqlMapConfigParser.this.vars).parse(reader);
            }
        });
    }

    private void registerDefaultTypeAliases() {
        this.vars.typeHandlerFactory.putTypeAlias("JDBC", (class$com$ibatis$sqlmap$engine$transaction$jdbc$JdbcTransactionConfig == null ? (class$com$ibatis$sqlmap$engine$transaction$jdbc$JdbcTransactionConfig = SqlMapConfigParser.class$("com.ibatis.sqlmap.engine.transaction.jdbc.JdbcTransactionConfig")) : class$com$ibatis$sqlmap$engine$transaction$jdbc$JdbcTransactionConfig).getName());
        this.vars.typeHandlerFactory.putTypeAlias("JTA", (class$com$ibatis$sqlmap$engine$transaction$jta$JtaTransactionConfig == null ? (class$com$ibatis$sqlmap$engine$transaction$jta$JtaTransactionConfig = SqlMapConfigParser.class$("com.ibatis.sqlmap.engine.transaction.jta.JtaTransactionConfig")) : class$com$ibatis$sqlmap$engine$transaction$jta$JtaTransactionConfig).getName());
        this.vars.typeHandlerFactory.putTypeAlias("EXTERNAL", (class$com$ibatis$sqlmap$engine$transaction$external$ExternalTransactionConfig == null ? (class$com$ibatis$sqlmap$engine$transaction$external$ExternalTransactionConfig = SqlMapConfigParser.class$("com.ibatis.sqlmap.engine.transaction.external.ExternalTransactionConfig")) : class$com$ibatis$sqlmap$engine$transaction$external$ExternalTransactionConfig).getName());
        this.vars.typeHandlerFactory.putTypeAlias("SIMPLE", (class$com$ibatis$sqlmap$engine$datasource$SimpleDataSourceFactory == null ? (class$com$ibatis$sqlmap$engine$datasource$SimpleDataSourceFactory = SqlMapConfigParser.class$("com.ibatis.sqlmap.engine.datasource.SimpleDataSourceFactory")) : class$com$ibatis$sqlmap$engine$datasource$SimpleDataSourceFactory).getName());
        this.vars.typeHandlerFactory.putTypeAlias("DBCP", (class$com$ibatis$sqlmap$engine$datasource$DbcpDataSourceFactory == null ? (class$com$ibatis$sqlmap$engine$datasource$DbcpDataSourceFactory = SqlMapConfigParser.class$("com.ibatis.sqlmap.engine.datasource.DbcpDataSourceFactory")) : class$com$ibatis$sqlmap$engine$datasource$DbcpDataSourceFactory).getName());
        this.vars.typeHandlerFactory.putTypeAlias("JNDI", (class$com$ibatis$sqlmap$engine$datasource$JndiDataSourceFactory == null ? (class$com$ibatis$sqlmap$engine$datasource$JndiDataSourceFactory = SqlMapConfigParser.class$("com.ibatis.sqlmap.engine.datasource.JndiDataSourceFactory")) : class$com$ibatis$sqlmap$engine$datasource$JndiDataSourceFactory).getName());
        this.vars.typeHandlerFactory.putTypeAlias("FIFO", (class$com$ibatis$sqlmap$engine$cache$fifo$FifoCacheController == null ? (class$com$ibatis$sqlmap$engine$cache$fifo$FifoCacheController = SqlMapConfigParser.class$("com.ibatis.sqlmap.engine.cache.fifo.FifoCacheController")) : class$com$ibatis$sqlmap$engine$cache$fifo$FifoCacheController).getName());
        this.vars.typeHandlerFactory.putTypeAlias("LRU", (class$com$ibatis$sqlmap$engine$cache$lru$LruCacheController == null ? (class$com$ibatis$sqlmap$engine$cache$lru$LruCacheController = SqlMapConfigParser.class$("com.ibatis.sqlmap.engine.cache.lru.LruCacheController")) : class$com$ibatis$sqlmap$engine$cache$lru$LruCacheController).getName());
        this.vars.typeHandlerFactory.putTypeAlias("MEMORY", (class$com$ibatis$sqlmap$engine$cache$memory$MemoryCacheController == null ? (class$com$ibatis$sqlmap$engine$cache$memory$MemoryCacheController = SqlMapConfigParser.class$("com.ibatis.sqlmap.engine.cache.memory.MemoryCacheController")) : class$com$ibatis$sqlmap$engine$cache$memory$MemoryCacheController).getName());
        this.vars.typeHandlerFactory.putTypeAlias("OSCACHE", "com.ibatis.sqlmap.engine.cache.oscache.OSCacheController");
        this.vars.typeHandlerFactory.putTypeAlias("dom", (class$com$ibatis$sqlmap$engine$type$DomTypeMarker == null ? (class$com$ibatis$sqlmap$engine$type$DomTypeMarker = SqlMapConfigParser.class$("com.ibatis.sqlmap.engine.type.DomTypeMarker")) : class$com$ibatis$sqlmap$engine$type$DomTypeMarker).getName());
        this.vars.typeHandlerFactory.putTypeAlias("domCollection", (class$com$ibatis$sqlmap$engine$type$DomCollectionTypeMarker == null ? (class$com$ibatis$sqlmap$engine$type$DomCollectionTypeMarker = SqlMapConfigParser.class$("com.ibatis.sqlmap.engine.type.DomCollectionTypeMarker")) : class$com$ibatis$sqlmap$engine$type$DomCollectionTypeMarker).getName());
        this.vars.typeHandlerFactory.putTypeAlias("xml", (class$com$ibatis$sqlmap$engine$type$XmlTypeMarker == null ? (class$com$ibatis$sqlmap$engine$type$XmlTypeMarker = SqlMapConfigParser.class$("com.ibatis.sqlmap.engine.type.XmlTypeMarker")) : class$com$ibatis$sqlmap$engine$type$XmlTypeMarker).getName());
        this.vars.typeHandlerFactory.putTypeAlias("xmlCollection", (class$com$ibatis$sqlmap$engine$type$XmlCollectionTypeMarker == null ? (class$com$ibatis$sqlmap$engine$type$XmlCollectionTypeMarker = SqlMapConfigParser.class$("com.ibatis.sqlmap.engine.type.XmlCollectionTypeMarker")) : class$com$ibatis$sqlmap$engine$type$XmlCollectionTypeMarker).getName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

