/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.store.DiskStore;
import net.sf.ehcache.store.MemoryStore;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Cache
implements Cloneable {
    public static final String DEFAULT_CACHE_NAME = "default";
    public static final String NET_SF_EHCACHE_DISABLED = "net.sf.ehcache.disabled";
    public static final long DEFAULT_EXPIRY_THREAD_INTERVAL_SECONDS = 120L;
    private static final Log LOG = LogFactory.getLog((String)(class$net$sf$ehcache$Cache == null ? (class$net$sf$ehcache$Cache = Cache.class$("net.sf.ehcache.Cache")) : class$net$sf$ehcache$Cache).getName());
    private static final int MS_PER_SECOND = 1000;
    private static final MemoryStoreEvictionPolicy DEFAULT_MEMORY_STORE_EVICTION_POLICY = MemoryStoreEvictionPolicy.LRU;
    private boolean disabled;
    private String name;
    private DiskStore diskStore;
    private final String diskStorePath;
    private Status status;
    private final int maxElementsInMemory;
    private MemoryStoreEvictionPolicy memoryStoreEvictionPolicy;
    private final boolean overflowToDisk;
    private final long diskExpiryThreadIntervalSeconds;
    private final boolean diskPersistent;
    private Thread shutdownHook;
    private final boolean eternal;
    private final long timeToLiveSeconds;
    private final long timeToIdleSeconds;
    private int hitCount;
    private int memoryStoreHitCount;
    private int diskStoreHitCount;
    private int missCountNotFound;
    private int missCountExpired;
    private MemoryStore memoryStore;
    private RegisteredEventListeners registeredEventListeners;
    private String guid;
    private CacheManager cacheManager;
    static /* synthetic */ Class class$net$sf$ehcache$Cache;

    public Cache(String name, int maxElementsInMemory, boolean overflowToDisk, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds) {
        this(name, maxElementsInMemory, DEFAULT_MEMORY_STORE_EVICTION_POLICY, overflowToDisk, null, eternal, timeToLiveSeconds, timeToIdleSeconds, false, 120L, null);
    }

    public Cache(String name, int maxElementsInMemory, boolean overflowToDisk, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds, boolean diskPersistent, long diskExpiryThreadIntervalSeconds) {
        this(name, maxElementsInMemory, DEFAULT_MEMORY_STORE_EVICTION_POLICY, overflowToDisk, null, eternal, timeToLiveSeconds, timeToIdleSeconds, diskPersistent, diskExpiryThreadIntervalSeconds, null);
    }

    public Cache(String name, int maxElementsInMemory, MemoryStoreEvictionPolicy memoryStoreEvictionPolicy, boolean overflowToDisk, String diskStorePath, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds, boolean diskPersistent, long diskExpiryThreadIntervalSeconds, RegisteredEventListeners registeredEventListeners) {
        String value = System.getProperty(NET_SF_EHCACHE_DISABLED);
        if (value != null) {
            this.disabled = value.equalsIgnoreCase("true");
        }
        try {
            this.guid = InetAddress.getLocalHost() + "-" + new UID();
        }
        catch (UnknownHostException e) {
            LOG.error((Object)("Could not create GUID: " + e.getMessage()));
        }
        this.name = name;
        this.maxElementsInMemory = maxElementsInMemory;
        this.memoryStoreEvictionPolicy = memoryStoreEvictionPolicy;
        this.overflowToDisk = overflowToDisk;
        this.eternal = eternal;
        this.timeToLiveSeconds = timeToLiveSeconds;
        this.timeToIdleSeconds = timeToIdleSeconds;
        this.diskPersistent = diskPersistent;
        this.diskStorePath = diskStorePath == null ? System.getProperty("java.io.tmpdir") : diskStorePath;
        this.registeredEventListeners = registeredEventListeners == null ? new RegisteredEventListeners(this) : registeredEventListeners;
        this.diskExpiryThreadIntervalSeconds = diskExpiryThreadIntervalSeconds == 0L ? 120L : diskExpiryThreadIntervalSeconds;
        if (memoryStoreEvictionPolicy == null) {
            this.memoryStoreEvictionPolicy = DEFAULT_MEMORY_STORE_EVICTION_POLICY;
        }
        this.changeStatus(Status.STATUS_UNINITIALISED);
    }

    final synchronized void initialise() {
        if (!this.status.equals(Status.STATUS_UNINITIALISED)) {
            throw new IllegalStateException("Cannot initialise the " + this.name + " cache because its status is not STATUS_UNINITIALISED");
        }
        if (this.maxElementsInMemory == 0 && LOG.isWarnEnabled()) {
            LOG.warn((Object)("Cache: " + this.name + " has a maxElementsInMemory of 0. It is strongly recommended to " + "have a maximumSize of at least 1. Performance is halved by not using a MemoryStore."));
        }
        if (this.overflowToDisk) {
            this.diskStore = new DiskStore(this, this.diskStorePath);
        }
        this.memoryStore = MemoryStore.create(this, this.diskStore);
        if (this.diskPersistent) {
            this.addShutdownHook();
        }
        this.changeStatus(Status.STATUS_ALIVE);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Initialised cache: " + this.name));
        }
        if (this.disabled && LOG.isWarnEnabled()) {
            LOG.warn((Object)("Cache: " + this.name + " is disabled because the " + NET_SF_EHCACHE_DISABLED + " property was set to true. No elements will be added to the cache."));
        }
    }

    private void changeStatus(Status status) {
        this.status = status;
    }

    private void addShutdownHook() {
        Thread localShutdownHook = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (Cache.this.status.equals(Status.STATUS_ALIVE)) {
                        Cache.this.shutdownHook = null;
                        LOG.debug((Object)("VM shutting down with the disk store for " + Cache.this.name + " still active. The disk store is persistent. Calling dispose..."));
                        Cache.this.dispose();
                    }
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(localShutdownHook);
        this.shutdownHook = localShutdownHook;
    }

    private void removeShutdownHook() {
        if (this.shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            this.shutdownHook.start();
            this.shutdownHook = null;
        }
    }

    public final synchronized void put(Element element) throws IllegalArgumentException, IllegalStateException, CacheException {
        this.put(element, false);
    }

    public final synchronized void put(Element element, boolean doNotNotifyCacheReplicators) throws IllegalArgumentException, IllegalStateException, CacheException {
        this.checkStatus();
        if (this.disabled) {
            return;
        }
        if (element == null) {
            throw new IllegalArgumentException("Element cannot be null");
        }
        element.resetAccessStatistics();
        boolean elementExists = false;
        if (this.registeredEventListeners != null) {
            Object key = element.getObjectKey();
            elementExists = this.isElementInMemory(key) || this.isElementOnDisk(key);
        }
        this.memoryStore.put(element);
        if (elementExists) {
            this.registeredEventListeners.notifyElementUpdated(element, doNotNotifyCacheReplicators);
        } else {
            this.registeredEventListeners.notifyElementPut(element, doNotNotifyCacheReplicators);
        }
    }

    public final synchronized void putQuiet(Element element) throws IllegalArgumentException, IllegalStateException, CacheException {
        this.checkStatus();
        if (this.disabled) {
            return;
        }
        if (element == null) {
            throw new IllegalArgumentException("Element cannot be null");
        }
        this.memoryStore.put(element);
    }

    public final synchronized Element get(Serializable key) throws IllegalStateException, CacheException {
        return this.get((Object)key);
    }

    public final synchronized Element get(Object key) throws IllegalStateException, CacheException {
        this.checkStatus();
        Element element = this.searchInMemoryStore(key, true);
        if (element == null && this.overflowToDisk) {
            element = this.searchInDiskStore(key, true);
        }
        if (element == null) {
            ++this.missCountNotFound;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)(this.name + " cache - Miss"));
            }
            return null;
        }
        ++this.hitCount;
        return element;
    }

    public final synchronized Element getQuiet(Serializable key) throws IllegalStateException, CacheException {
        return this.getQuiet((Object)key);
    }

    public final synchronized Element getQuiet(Object key) throws IllegalStateException, CacheException {
        this.checkStatus();
        Element element = this.searchInMemoryStore(key, false);
        if (element == null && this.overflowToDisk) {
            element = this.searchInDiskStore(key, false);
        }
        if (element == null) {
            ++this.missCountNotFound;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)(this.name + " cache - Miss"));
            }
            return null;
        }
        ++this.hitCount;
        return element;
    }

    public final synchronized List getKeys() throws IllegalStateException, CacheException {
        this.checkStatus();
        ArrayList<Object> allKeyList = new ArrayList<Object>();
        List<Object> keyList = Arrays.asList(this.memoryStore.getKeyArray());
        allKeyList.addAll(keyList);
        if (this.overflowToDisk) {
            HashSet<Object> allKeys = new HashSet<Object>();
            allKeys.addAll(keyList);
            Object[] diskKeys = this.diskStore.getKeyArray();
            for (int i = 0; i < diskKeys.length; ++i) {
                Object diskKey = diskKeys[i];
                if (!allKeys.add(diskKey)) continue;
                allKeyList.add(diskKey);
            }
        }
        return allKeyList;
    }

    public final List getKeysWithExpiryCheck() throws IllegalStateException, CacheException {
        List allKeyList = this.getKeys();
        ArrayList nonExpiredKeys = new ArrayList(allKeyList.size());
        int allKeyListSize = allKeyList.size();
        for (int i = 0; i < allKeyListSize; ++i) {
            Object key = allKeyList.get(i);
            Element element = this.getQuiet(key);
            if (element == null) continue;
            nonExpiredKeys.add(key);
        }
        nonExpiredKeys.trimToSize();
        return nonExpiredKeys;
    }

    public final synchronized List getKeysNoDuplicateCheck() throws IllegalStateException {
        this.checkStatus();
        ArrayList<Object> allKeys = new ArrayList<Object>();
        List<Object> memoryKeySet = Arrays.asList(this.memoryStore.getKeyArray());
        allKeys.addAll(memoryKeySet);
        if (this.overflowToDisk) {
            List<Object> diskKeySet = Arrays.asList(this.diskStore.getKeyArray());
            allKeys.addAll(diskKeySet);
        }
        return allKeys;
    }

    private Element searchInMemoryStore(Object key, boolean updateStatistics) {
        Element element = updateStatistics ? this.memoryStore.get(key) : this.memoryStore.getQuiet(key);
        if (element != null) {
            if (this.isExpired(element)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.name + " Memory cache hit, but element expired"));
                }
                ++this.missCountExpired;
                this.remove(key, true, true, false);
                element = null;
            } else {
                ++this.memoryStoreHitCount;
            }
        }
        return element;
    }

    private Element searchInDiskStore(Object key, boolean updateStatistics) {
        if (!(key instanceof Serializable)) {
            return null;
        }
        Serializable serializableKey = (Serializable)key;
        Element element = updateStatistics ? this.diskStore.get(serializableKey) : this.diskStore.getQuiet(serializableKey);
        if (element != null) {
            if (this.isExpired(element)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.name + " cache - Disk Store hit, but element expired"));
                }
                ++this.missCountExpired;
                this.remove(key, true, true, false);
                element = null;
            } else {
                ++this.diskStoreHitCount;
                this.memoryStore.put(element);
            }
        }
        return element;
    }

    public final synchronized boolean remove(Serializable key) throws IllegalStateException {
        return this.remove((Object)key);
    }

    public final synchronized boolean remove(Object key) throws IllegalStateException {
        return this.remove(key, false);
    }

    public final synchronized boolean remove(Serializable key, boolean doNotNotifyCacheReplicators) throws IllegalStateException {
        return this.remove((Object)key, doNotNotifyCacheReplicators);
    }

    public final synchronized boolean remove(Object key, boolean doNotNotifyCacheReplicators) throws IllegalStateException {
        return this.remove(key, false, true, doNotNotifyCacheReplicators);
    }

    public final synchronized boolean removeQuiet(Serializable key) throws IllegalStateException {
        return this.remove(key, false, false, false);
    }

    public final synchronized boolean removeQuiet(Object key) throws IllegalStateException {
        return this.remove(key, false, false, false);
    }

    private synchronized boolean remove(Object key, boolean expiry, boolean notifyListeners, boolean doNotNotifyCacheReplicators) throws IllegalStateException, CacheException {
        this.checkStatus();
        boolean removed = false;
        Element elementFromMemoryStore = this.memoryStore.remove(key);
        if (elementFromMemoryStore != null) {
            if (notifyListeners) {
                if (expiry) {
                    this.registeredEventListeners.notifyElementExpiry(elementFromMemoryStore, doNotNotifyCacheReplicators);
                } else {
                    this.registeredEventListeners.notifyElementRemoved(elementFromMemoryStore, doNotNotifyCacheReplicators);
                }
            }
            removed = true;
        }
        Element elementFromDiskStore = null;
        if (this.overflowToDisk) {
            if (!(key instanceof Serializable)) {
                return false;
            }
            Serializable serializableKey = (Serializable)key;
            elementFromDiskStore = this.diskStore.remove(serializableKey);
        }
        if (elementFromDiskStore != null) {
            if (expiry) {
                this.registeredEventListeners.notifyElementExpiry(elementFromDiskStore, doNotNotifyCacheReplicators);
            } else {
                this.registeredEventListeners.notifyElementRemoved(elementFromDiskStore, doNotNotifyCacheReplicators);
            }
            removed = true;
        }
        return removed;
    }

    public final synchronized void removeAll() throws IllegalStateException, IOException, CacheException {
        this.checkStatus();
        this.memoryStore.removeAll();
        if (this.overflowToDisk) {
            this.diskStore.removeAll();
        }
    }

    final synchronized void dispose() throws IllegalStateException {
        this.checkStatus();
        this.memoryStore.dispose();
        this.memoryStore = null;
        if (this.overflowToDisk) {
            this.diskStore.dispose();
            this.diskStore = null;
        }
        this.registeredEventListeners.dispose();
        this.changeStatus(Status.STATUS_SHUTDOWN);
        if (this.diskPersistent) {
            this.removeShutdownHook();
        }
    }

    public final synchronized void flush() throws IllegalStateException, CacheException {
        this.checkStatus();
        try {
            this.memoryStore.flush();
            if (this.overflowToDisk) {
                this.diskStore.flush();
            }
        }
        catch (IOException e) {
            throw new CacheException("Unable to flush cache: " + this.name + ". Initial cause was " + e.getMessage(), e);
        }
    }

    public final synchronized int getSize() throws IllegalStateException, CacheException {
        this.checkStatus();
        return this.getKeys().size();
    }

    public final synchronized long calculateInMemorySize() throws IllegalStateException, CacheException {
        this.checkStatus();
        return this.memoryStore.getSizeInBytes();
    }

    public final long getMemoryStoreSize() throws IllegalStateException {
        this.checkStatus();
        return this.memoryStore.getSize();
    }

    public final int getDiskStoreSize() throws IllegalStateException {
        this.checkStatus();
        if (this.overflowToDisk) {
            return this.diskStore.getSize();
        }
        return 0;
    }

    public final Status getStatus() {
        return this.status;
    }

    private void checkStatus() throws IllegalStateException {
        if (!this.status.equals(Status.STATUS_ALIVE)) {
            throw new IllegalStateException("The " + this.name + " Cache is not alive.");
        }
    }

    public final int getHitCount() throws IllegalStateException {
        this.checkStatus();
        return this.hitCount;
    }

    public final int getMemoryStoreHitCount() throws IllegalStateException {
        this.checkStatus();
        return this.memoryStoreHitCount;
    }

    public final int getDiskStoreHitCount() throws IllegalStateException {
        this.checkStatus();
        return this.diskStoreHitCount;
    }

    public final int getMissCountNotFound() throws IllegalStateException {
        this.checkStatus();
        return this.missCountNotFound;
    }

    public final int getMissCountExpired() throws IllegalStateException {
        this.checkStatus();
        return this.missCountExpired;
    }

    public final String getName() {
        return this.name;
    }

    final void setName(String name) {
        this.name = name;
    }

    public final long getTimeToIdleSeconds() {
        return this.timeToIdleSeconds;
    }

    public final long getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    public final boolean isEternal() {
        return this.eternal;
    }

    public final boolean isOverflowToDisk() {
        return this.overflowToDisk;
    }

    public final int getMaxElementsInMemory() {
        return this.maxElementsInMemory;
    }

    public final MemoryStoreEvictionPolicy getMemoryStoreEvictionPolicy() {
        return this.memoryStoreEvictionPolicy;
    }

    public final String toString() {
        StringBuffer dump = new StringBuffer();
        dump.append("[ ").append(" name = ").append(this.name).append(" status = ").append(this.status).append(" eternal = ").append(this.eternal).append(" overflowToDisk = ").append(this.overflowToDisk).append(" maxElementsInMemory = ").append(this.maxElementsInMemory).append(" memoryStoreEvictionPolicy = ").append(this.memoryStoreEvictionPolicy).append(" timeToLiveSeconds = ").append(this.timeToLiveSeconds).append(" timeToIdleSeconds = ").append(this.timeToIdleSeconds).append(" diskPersistent = ").append(this.diskPersistent).append(" diskExpiryThreadIntervalSeconds = ").append(this.diskExpiryThreadIntervalSeconds).append(this.registeredEventListeners).append(" hitCount = ").append(this.hitCount).append(" memoryStoreHitCount = ").append(this.memoryStoreHitCount).append(" diskStoreHitCount = ").append(this.diskStoreHitCount).append(" missCountNotFound = ").append(this.missCountNotFound).append(" missCountExpired = ").append(this.missCountExpired).append(" ]");
        return dump.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isExpired(Element element) throws IllegalStateException, NullPointerException {
        this.checkStatus();
        Element element2 = element;
        synchronized (element2) {
            boolean expired = !this.eternal ? this.checkExpirationForNotEternal(element) : false;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getName() + ": Is element with key " + element.getObjectKey() + " expired?: " + expired));
            }
            return expired;
        }
    }

    private boolean checkExpirationForNotEternal(Element element) {
        boolean expired;
        long now = System.currentTimeMillis();
        long creationTime = element.getCreationTime();
        long ageLived = now - creationTime;
        long ageToLive = this.timeToLiveSeconds * 1000L;
        long nextToLastAccessTime = element.getNextToLastAccessTime();
        long mostRecentTime = Math.max(creationTime, nextToLastAccessTime);
        long ageIdled = now - mostRecentTime;
        long ageToIdle = this.timeToIdleSeconds * 1000L;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(element.getObjectKey() + " now: " + now));
            LOG.trace((Object)(element.getObjectKey() + " Creation Time: " + creationTime + " Next To Last Access Time: " + nextToLastAccessTime));
            LOG.trace((Object)(element.getObjectKey() + " mostRecentTime: " + mostRecentTime));
            LOG.trace((Object)(element.getObjectKey() + " Age to Idle: " + ageToIdle + " Age Idled: " + ageIdled));
        }
        if (this.timeToLiveSeconds != 0L && ageLived > ageToLive) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("timeToLiveSeconds exceeded : " + element.getObjectKey()));
            }
            expired = true;
        } else if (this.timeToIdleSeconds != 0L && ageIdled > ageToIdle) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("timeToIdleSeconds exceeded : " + element.getObjectKey()));
            }
            expired = true;
        } else {
            expired = false;
        }
        return expired;
    }

    public final Object clone() throws CloneNotSupportedException {
        if (this.memoryStore != null || this.diskStore != null) {
            throw new CloneNotSupportedException("Cannot clone an initialized cache.");
        }
        Cache copy = (Cache)super.clone();
        RegisteredEventListeners registeredEventListenersFromCopy = copy.getCacheEventNotificationService();
        if (registeredEventListenersFromCopy != null && registeredEventListenersFromCopy.getCacheEventListeners().size() != 0) {
            throw new CloneNotSupportedException("Cannot clone a cache with registered event listeners");
        }
        copy.registeredEventListeners = new RegisteredEventListeners(copy);
        return copy;
    }

    final DiskStore getDiskStore() throws IllegalStateException {
        this.checkStatus();
        return this.diskStore;
    }

    final MemoryStore getMemoryStore() throws IllegalStateException {
        this.checkStatus();
        return this.memoryStore;
    }

    public final boolean isDiskPersistent() {
        return this.diskPersistent;
    }

    public final long getDiskExpiryThreadIntervalSeconds() {
        return this.diskExpiryThreadIntervalSeconds;
    }

    public final RegisteredEventListeners getCacheEventNotificationService() {
        return this.registeredEventListeners;
    }

    public final boolean isElementInMemory(Serializable key) {
        return this.isElementInMemory((Object)key);
    }

    public final boolean isElementInMemory(Object key) {
        return this.memoryStore.containsKey(key);
    }

    public final boolean isElementOnDisk(Serializable key) {
        return this.isElementOnDisk((Object)key);
    }

    public final boolean isElementOnDisk(Object key) {
        if (!(key instanceof Serializable)) {
            return false;
        }
        Serializable serializableKey = (Serializable)key;
        return this.diskStore != null && this.diskStore.containsKey(serializableKey);
    }

    public final String getGuid() {
        return this.guid;
    }

    public final CacheManager getCacheManager() {
        return this.cacheManager;
    }

    final void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

