/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import java.rmi.NotBoundException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.distribution.CachePeer;
import net.sf.ehcache.distribution.RMICacheManagerPeerProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ManualRMICacheManagerPeerProvider
extends RMICacheManagerPeerProvider {
    private static final Log LOG = LogFactory.getLog((String)(class$net$sf$ehcache$distribution$ManualRMICacheManagerPeerProvider == null ? (class$net$sf$ehcache$distribution$ManualRMICacheManagerPeerProvider = ManualRMICacheManagerPeerProvider.class$("net.sf.ehcache.distribution.ManualRMICacheManagerPeerProvider")) : class$net$sf$ehcache$distribution$ManualRMICacheManagerPeerProvider).getName());
    static /* synthetic */ Class class$net$sf$ehcache$distribution$ManualRMICacheManagerPeerProvider;

    public final void init() {
    }

    public final synchronized void registerPeer(String rmiUrl) {
        this.peerUrls.put(rmiUrl, new Date());
    }

    public final synchronized List listRemoteCachePeers(Cache cache) throws CacheException {
        String rmiUrl;
        ArrayList<CachePeer> remoteCachePeers = new ArrayList<CachePeer>();
        ArrayList<String> staleList = new ArrayList<String>();
        Iterator iterator = this.peerUrls.keySet().iterator();
        while (iterator.hasNext()) {
            rmiUrl = (String)iterator.next();
            String rmiUrlCacheName = ManualRMICacheManagerPeerProvider.extractCacheName(rmiUrl);
            try {
                if (!rmiUrlCacheName.equals(cache.getName())) continue;
                Date date = (Date)this.peerUrls.get(rmiUrl);
                if (!this.stale(date)) {
                    CachePeer cachePeer = ManualRMICacheManagerPeerProvider.lookupRemoteCachePeer(rmiUrl);
                    remoteCachePeers.add(cachePeer);
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("rmiUrl " + rmiUrl + " is stale. Either the remote peer is shutdown or the " + "network connectivity has been interrupted. Will be removed from list of remote cache peers"));
                }
                staleList.add(rmiUrl);
            }
            catch (NotBoundException e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("No cache peer bound to URL at " + rmiUrl + ". It must have disappeared since the last heartbeat"));
            }
            catch (Exception exception) {
                LOG.error((Object)exception.getMessage(), (Throwable)exception);
                throw new CacheException("Unable to list remote cache peers. Error was " + exception.getMessage());
            }
        }
        for (int i = 0; i < staleList.size(); ++i) {
            rmiUrl = (String)staleList.get(i);
            this.peerUrls.remove(rmiUrl);
        }
        return remoteCachePeers;
    }

    protected final boolean stale(Date date) {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

