/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap.protocol;

import java.util.Vector;

public final class UIDSet {
    public long start;
    public long end;

    public UIDSet() {
    }

    public UIDSet(long start, long end) {
        this.start = start;
        this.end = end;
    }

    public long size() {
        return this.end - this.start + 1L;
    }

    public static UIDSet[] createUIDSets(long[] al) {
        Vector<UIDSet> vector = new Vector<UIDSet>();
        int i = 0;
        while (i < al.length) {
            UIDSet uidset = new UIDSet();
            uidset.start = al[i];
            int j = i + 1;
            while (j < al.length) {
                if (al[j] != al[j - 1] + 1L) break;
                ++j;
            }
            uidset.end = al[j - 1];
            vector.addElement(uidset);
            i = j - 1;
            ++i;
        }
        Object[] uidsets = new UIDSet[vector.size()];
        vector.copyInto(uidsets);
        return uidsets;
    }

    public static String toString(UIDSet[] uidsets) {
        if (uidsets == null || uidsets.length == 0) {
            return null;
        }
        int i = 0;
        StringBuffer sb = new StringBuffer();
        int length = uidsets.length;
        while (true) {
            long start;
            long end;
            if ((end = uidsets[i].end) > (start = uidsets[i].start)) {
                sb.append(start).append(':').append(end);
            } else {
                sb.append(start);
            }
            if (++i >= length) break;
            sb.append(',');
        }
        return sb.toString();
    }

    public static long size(UIDSet[] uidsets) {
        if (uidsets == null) {
            return 0L;
        }
        long size = 0L;
        int i = 0;
        while (i < uidsets.length) {
            size += uidsets[i].size();
            ++i;
        }
        return size;
    }
}

