/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import com.sun.mail.util.ASCIIUtility;
import com.sun.mail.util.LineInputStream;
import com.sun.mail.util.LineOutputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessageAware;
import javax.mail.MessageContext;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.MultipartDataSource;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.SharedInputStream;
import javax.mail.internet.UniqueValue;

public final class MimeMultipart
extends Multipart {
    private static boolean ignoreMissingEndBoundary = true;
    private static boolean ignoreMissingBoundaryParameter = true;
    private static boolean bmparse = true;
    protected DataSource ds = null;
    protected boolean parsed = true;
    private boolean complete = true;
    private String preamble = null;

    static {
        try {
            String s = System.getProperty("mail.mime.multipart.ignoremissingendboundary");
            ignoreMissingEndBoundary = s == null || !s.equalsIgnoreCase("false");
            s = System.getProperty("mail.mime.multipart.ignoremissingboundaryparameter");
            ignoreMissingBoundaryParameter = s == null || !s.equalsIgnoreCase("false");
            s = System.getProperty("mail.mime.multipart.bmparse");
            bmparse = s == null || !s.equalsIgnoreCase("false");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public MimeMultipart() {
        this("mixed");
    }

    public MimeMultipart(String subtype) {
        String boundary = UniqueValue.getUniqueBoundaryValue();
        ContentType cType = new ContentType("multipart", subtype, null);
        cType.setParameter("boundary", boundary);
        this.contentType = cType.toString();
    }

    public MimeMultipart(DataSource ds) throws MessagingException {
        if (ds instanceof MessageAware) {
            MessageContext mc = ((MessageAware)ds).getMessageContext();
            this.setParent(mc.getPart());
        }
        if (ds instanceof MultipartDataSource) {
            this.setMultipartDataSource((MultipartDataSource)ds);
            return;
        }
        this.parsed = false;
        this.ds = ds;
        this.contentType = ds.getContentType();
    }

    public synchronized void setSubType(String subtype) throws MessagingException {
        ContentType cType = new ContentType(this.contentType);
        cType.setSubType(subtype);
        this.contentType = cType.toString();
    }

    public synchronized int getCount() throws MessagingException {
        this.parse();
        return super.getCount();
    }

    public synchronized BodyPart getBodyPart(int index) throws MessagingException {
        this.parse();
        return super.getBodyPart(index);
    }

    public synchronized BodyPart getBodyPart(String CID) throws MessagingException {
        this.parse();
        int count = this.getCount();
        int i = 0;
        while (i < count) {
            MimeBodyPart part = (MimeBodyPart)this.getBodyPart(i);
            String s = part.getContentID();
            if (s != null && s.equals(CID)) {
                return part;
            }
            ++i;
        }
        return null;
    }

    public boolean isComplete() throws MessagingException {
        this.parse();
        return this.complete;
    }

    public String getPreamble() throws MessagingException {
        this.parse();
        return this.preamble;
    }

    public void setPreamble(String preamble) throws MessagingException {
        this.preamble = preamble;
    }

    protected void updateHeaders() throws MessagingException {
        int i = 0;
        while (i < this.parts.size()) {
            ((MimeBodyPart)this.parts.elementAt(i)).updateHeaders();
            ++i;
        }
    }

    public void writeTo(OutputStream os) throws IOException, MessagingException {
        this.parse();
        String boundary = "--" + new ContentType(this.contentType).getParameter("boundary");
        LineOutputStream los = new LineOutputStream(os);
        if (this.preamble != null) {
            byte[] bytes = ASCIIUtility.getBytes(this.preamble);
            los.write(bytes);
            if (bytes.length > 0 && bytes[bytes.length - 1] != 13 && bytes[bytes.length - 1] != 10) {
                los.writeln();
            }
        }
        int i = 0;
        while (i < this.parts.size()) {
            los.writeln(boundary);
            ((MimeBodyPart)this.parts.elementAt(i)).writeTo(os);
            los.writeln();
            ++i;
        }
        los.writeln(String.valueOf(boundary) + "--");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void parse() throws MessagingException {
        if (this.parsed) {
            return;
        }
        if (bmparse) {
            this.parsebm();
            return;
        }
        InputStream in = null;
        SharedInputStream sin = null;
        long start = 0L;
        long end = 0L;
        try {
            in = this.ds.getInputStream();
            if (!(in instanceof ByteArrayInputStream || in instanceof BufferedInputStream || in instanceof SharedInputStream)) {
                in = new BufferedInputStream(in);
            }
        }
        catch (Exception ex) {
            throw new MessagingException("No inputstream from datasource");
        }
        if (in instanceof SharedInputStream) {
            sin = (SharedInputStream)((Object)in);
        }
        ContentType cType = new ContentType(this.contentType);
        String boundary = null;
        String s1 = cType.getParameter("boundary");
        if (s1 != null) {
            boundary = "--" + s1;
        } else if (!ignoreMissingBoundaryParameter) {
            throw new MessagingException("Missing boundary parameter");
        }
        try {
            try {
                String line;
                LineInputStream lin = new LineInputStream(in);
                String separator = null;
                while ((line = lin.readLine()) != null) {
                    char c;
                    int i = line.length() - 1;
                    while (i >= 0 && ((c = line.charAt(i)) == ' ' || c == '\t')) {
                        --i;
                    }
                    line = line.substring(0, i + 1);
                    if (boundary != null) {
                        if (line.equals(boundary)) {
                            break;
                        }
                    } else if (line.startsWith("--")) {
                        boundary = line;
                        break;
                    }
                    if (line.length() <= 0) continue;
                    if (separator == null) {
                        try {
                            separator = System.getProperty("line.separator", "\n");
                        }
                        catch (SecurityException sex) {
                            separator = "\n";
                        }
                    }
                    if (this.preamble == null) {
                        this.preamble = String.valueOf(line) + separator;
                        continue;
                    }
                    this.preamble = String.valueOf(this.preamble) + line + separator;
                }
                if (line == null) {
                    throw new MessagingException("Missing start boundary");
                }
                byte[] bndbytes = ASCIIUtility.getBytes(boundary);
                int bl = bndbytes.length;
                boolean done = false;
                while (!done) {
                    InternetHeaders headers = null;
                    if (sin != null) {
                        start = sin.getPosition();
                        while ((line = lin.readLine()) != null && line.length() > 0) {
                        }
                        if (line == null) {
                            if (!ignoreMissingEndBoundary) {
                                throw new MessagingException("missing multipart end boundary");
                            }
                            this.complete = false;
                            break;
                        }
                    } else {
                        headers = this.createInternetHeaders(in);
                    }
                    if (!in.markSupported()) {
                        throw new MessagingException("Stream doesn't support mark");
                    }
                    ByteArrayOutputStream buf = null;
                    if (sin == null) {
                        buf = new ByteArrayOutputStream();
                    } else {
                        end = sin.getPosition();
                    }
                    boolean bol = true;
                    int eol1 = -1;
                    int eol2 = -1;
                    block17: while (true) {
                        int b;
                        if (bol) {
                            in.mark(bl + 4 + 1000);
                            int i = 0;
                            while (i < bl && in.read() == (bndbytes[i] & 0xFF)) {
                                ++i;
                            }
                            if (i == bl) {
                                int b2 = in.read();
                                if (b2 == 45 && in.read() == 45) {
                                    this.complete = true;
                                    done = true;
                                    break;
                                }
                                while (true) {
                                    if (b2 != 32 && b2 != 9) {
                                        if (b2 != 10) break;
                                        break block17;
                                    }
                                    b2 = in.read();
                                }
                                if (b2 == 13) {
                                    in.mark(1);
                                    if (in.read() == 10) break;
                                    in.reset();
                                    break;
                                }
                            }
                            in.reset();
                            if (buf != null && eol1 != -1) {
                                buf.write(eol1);
                                if (eol2 != -1) {
                                    buf.write(eol2);
                                }
                                eol2 = -1;
                                eol1 = -1;
                            }
                        }
                        if ((b = in.read()) < 0) {
                            if (!ignoreMissingEndBoundary) {
                                throw new MessagingException("missing multipart end boundary");
                            }
                            this.complete = false;
                            done = true;
                            break;
                        }
                        if (b == 13 || b == 10) {
                            bol = true;
                            if (sin != null) {
                                end = sin.getPosition() - 1L;
                            }
                            eol1 = b;
                            if (b != 13) continue;
                            in.mark(1);
                            b = in.read();
                            if (b == 10) {
                                eol2 = b;
                                continue;
                            }
                            in.reset();
                            continue;
                        }
                        bol = false;
                        if (buf == null) continue;
                        buf.write(b);
                    }
                    MimeBodyPart part = sin != null ? this.createMimeBodyPart(sin.newStream(start, end)) : this.createMimeBodyPart(headers, buf.toByteArray());
                    this.addBodyPart(part);
                }
            }
            catch (IOException ioex) {
                throw new MessagingException("IO Error", ioex);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        this.parsed = true;
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void parsebm() throws MessagingException {
        if (this.parsed) {
            return;
        }
        in = null;
        sin = null;
        start = 0L;
        end = 0L;
        try {
            in = this.ds.getInputStream();
            if (!(in instanceof ByteArrayInputStream || in instanceof BufferedInputStream || in instanceof SharedInputStream)) {
                in = new BufferedInputStream(in);
            }
        }
        catch (Exception ex) {
            throw new MessagingException("No inputstream from datasource");
        }
        if (in instanceof SharedInputStream) {
            sin = (SharedInputStream)in;
        }
        cType = new ContentType(this.contentType);
        boundary = null;
        s1 = cType.getParameter("boundary");
        if (s1 != null) {
            boundary = "--" + s1;
        } else if (!MimeMultipart.ignoreMissingBoundaryParameter) {
            throw new MessagingException("Missing boundary parameter");
        }
        try {
            try {
                lin = new LineInputStream(in);
                separator = null;
                while ((line = lin.readLine()) != null) {
                    i = line.length() - 1;
                    while (i >= 0) {
                        c = line.charAt(i);
                        if (c != ' ' && c != '\t') break;
                        --i;
                    }
                    line = line.substring(0, i + 1);
                    if (boundary != null) {
                        if (line.equals(boundary)) {
                            break;
                        }
                    } else if (line.startsWith("--")) {
                        boundary = line;
                        break;
                    }
                    if (line.length() <= 0) continue;
                    if (separator == null) {
                        try {
                            separator = System.getProperty("line.separator", "\n");
                        }
                        catch (SecurityException securityexception) {
                            separator = "\n";
                        }
                    }
                    this.preamble = this.preamble == null ? String.valueOf(line) + separator : String.valueOf(this.preamble) + line + separator;
                }
                if (line == null) {
                    throw new MessagingException("Missing start boundary");
                }
                bndbytes = ASCIIUtility.getBytes(boundary);
                bl = bndbytes.length;
                ai = new int[256];
                i = 0;
                while (i < bl) {
                    ai[bndbytes[i]] = i + 1;
                    ++i;
                }
                ai1 = new int[bl];
                i = bl;
                while (i > 0) {
                    block61: {
                        j = bl - 1;
                        while (j >= i) {
                            if (bndbytes[j] == bndbytes[j - i]) {
                                ai1[j - 1] = i;
                                --j;
                                continue;
                            }
                            break block61;
                        }
                        while (j > 0) {
                            ai1[--j] = i;
                        }
                    }
                    --i;
                }
                ai1[bl - 1] = 1;
                done = false;
                while (!done) {
                    headers = null;
                    if (sin != null) {
                        start = sin.getPosition();
                        while ((line = lin.readLine()) != null && line.length() > 0) {
                        }
                        if (line == null) {
                            if (!MimeMultipart.ignoreMissingEndBoundary) {
                                throw new MessagingException("missing multipart end boundary");
                            }
                            this.complete = false;
                            break;
                        }
                    } else {
                        headers = this.createInternetHeaders(in);
                    }
                    if (!in.markSupported()) {
                        throw new MessagingException("Stream doesn't support mark");
                    }
                    buf = null;
                    if (sin == null) {
                        buf = new ByteArrayOutputStream();
                    } else {
                        end = sin.getPosition();
                    }
                    abyte1 = new byte[bl];
                    abyte2 = new byte[bl];
                    i = 0;
                    i2 = 0;
                    bol = true;
                    while (true) {
                        block63: {
                            block64: {
                                in.mark(bl + 4 + 1000);
                                j2 = 0;
                                i = in.read(abyte1, 0, bl);
                                if (i < bl) {
                                    if (!MimeMultipart.ignoreMissingEndBoundary) {
                                        throw new MessagingException("missing multipart end boundary");
                                    }
                                    if (sin != null) {
                                        end = sin.getPosition();
                                    }
                                    this.complete = false;
                                    done = true;
                                    break;
                                }
                                k2 = bl - 1;
                                while (k2 >= 0) {
                                    if (abyte1[k2] != bndbytes[k2]) break;
                                    --k2;
                                }
                                if (k2 >= 0) break block63;
                                j2 = 0;
                                if (!(bol || (b = abyte2[i2 - 1]) != 13 && b != 10)) {
                                    j2 = 1;
                                    if (b == 10 && i2 >= 2 && abyte2[i2 - 2] == 13) {
                                        j2 = 2;
                                    }
                                }
                                if (!bol && j2 <= 0) break block64;
                                if (sin != null) {
                                    end = sin.getPosition() - (long)bl - (long)j2;
                                }
                                if ((b2 = in.read()) != 45 || in.read() != 45) ** GOTO lbl136
                                this.complete = true;
                                done = true;
                                break;
lbl-1000:
                                // 1 sources

                                {
                                    b2 = in.read();
lbl136:
                                    // 2 sources

                                    ** while (b2 == 32 || b2 == 9)
                                }
lbl137:
                                // 1 sources

                                if (b2 == 10) break;
                                if (b2 == 13) {
                                    in.mark(1);
                                    if (in.read() == 10) break;
                                    in.reset();
                                    break;
                                }
                            }
                            k2 = 0;
                        }
                        if ((max = Math.max(k2 + 1 - ai[abyte1[k2] & 127], ai1[k2])) < 2) {
                            if (sin == null && i2 > 1) {
                                buf.write(abyte2, 0, i2 - 1);
                            }
                            in.reset();
                            in.skip(1L);
                            if (i2 >= 1) {
                                abyte2[0] = abyte2[i2 - 1];
                                abyte2[1] = abyte1[0];
                                i2 = 2;
                            } else {
                                abyte2[0] = abyte1[0];
                                i2 = 1;
                            }
                        } else {
                            if (i2 > 0 && sin == null) {
                                buf.write(abyte2, 0, i2);
                            }
                            i2 = max;
                            in.reset();
                            in.skip(i2);
                            abyte3 = abyte1;
                            abyte1 = abyte2;
                            abyte2 = abyte3;
                        }
                        bol = false;
                    }
                    if (sin != null) {
                        part = this.createMimeBodyPart(sin.newStream(start, end));
                    } else {
                        if (i2 - j2 > 0) {
                            buf.write(abyte2, 0, i2 - j2);
                        }
                        if (!this.complete && i > 0) {
                            buf.write(abyte1, 0, i);
                        }
                        part = this.createMimeBodyPart(headers, buf.toByteArray());
                    }
                    this.addBodyPart(part);
                }
            }
            catch (IOException ioex) {
                throw new MessagingException("IO Error", ioex);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException var30_37) {}
        }
        this.parsed = true;
    }

    protected InternetHeaders createInternetHeaders(InputStream is) throws MessagingException {
        return new InternetHeaders(is);
    }

    protected MimeBodyPart createMimeBodyPart(InternetHeaders headers, byte[] content) {
        return new MimeBodyPart(headers, content);
    }

    protected MimeBodyPart createMimeBodyPart(InputStream is) throws MessagingException {
        return new MimeBodyPart(is);
    }
}

