/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.mail.util;

final class StringUtils {
    public static final String EMPTY = "";
    private static final int PAD_LIMIT = 8192;
    private static final String[] PADDING = new String[65535];

    private StringUtils() {
    }

    public static String repeat(String str, int repeat) {
        if (str == null) {
            return null;
        }
        if (repeat <= 0) {
            return EMPTY;
        }
        int inputLength = str.length();
        if (repeat == 1 || inputLength == 0) {
            return str;
        }
        if (inputLength == 1 && repeat <= 8192) {
            return StringUtils.padding(repeat, str.charAt(0));
        }
        int outputLength = inputLength * repeat;
        switch (inputLength) {
            case 1: {
                char ch = str.charAt(0);
                char[] output1 = new char[outputLength];
                int i = repeat - 1;
                while (i >= 0) {
                    output1[i] = ch;
                    --i;
                }
                return new String(output1);
            }
            case 2: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                char[] output2 = new char[outputLength];
                int i = repeat * 2 - 2;
                while (i >= 0) {
                    output2[i] = ch0;
                    output2[i + 1] = ch1;
                    --i;
                    --i;
                }
                return new String(output2);
            }
        }
        StringBuffer buf = new StringBuffer(outputLength);
        int i = 0;
        while (i < repeat) {
            buf.append(str);
            ++i;
        }
        return buf.toString();
    }

    private static String padding(int repeat, char padChar) {
        String pad = PADDING[padChar];
        if (pad == null) {
            pad = String.valueOf(padChar);
        }
        while (pad.length() < repeat) {
            pad = pad.concat(pad);
        }
        StringUtils.PADDING[padChar] = pad;
        return pad.substring(0, repeat);
    }
}

