package org.lixm.core.model;

import org.lixm.core.common.XMLType;

/**
 * <p>属性をモデル化します。</p>
 * @author tasogare
 * @version 1.0M1
 *
 */
public class AttributeModel extends AbstractModel {

    private String name;
    private String value;
    private String pref;
    private String id;

    public AttributeModel(
        String name, String value, String pref, String id)
    {

        super(XMLType.ATTRIBUTE);
        this.name = name;
        this.value = value;
        this.pref = pref;
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public String getValue() {
        return value;
    }

    public String getPrefix() {
        return pref;
    }

    public String getNamespace() {
        return id;
    }

    public String toLocalName() {
        return getName( );
    }

    public String toQName() {

        String qName = "";
        if (getPrefix( ) != null) {
            qName = getPrefix( ) + ":" + getName( );
        } else {
            qName = null;
        }
        return qName;
    }

    public String getLocalPair() {
        return this.toLocalName( ) + "=" + "'" + this.getValue( ) + "'";
    }

    public String getQPair() {
        if (toQName( ) != null) {
            return this.toQName( ) + "=" + "'" + this.getValue( ) + "'";
        } else {
            return this.getLocalPair( );
        }
    }

    public String toString() {
        return getLocalPair( );
    }

    /*
     */
    public boolean equals(
        Object o)
    {
        if (!super.equals(o)) return false;
        return ( this.toString( ) == o.toString( ) );
    }

}
