package org.lixm.core.list;

import java.util.Iterator;
import java.util.NoSuchElementException;

import org.lixm.core.common.XMLType;
import org.lixm.core.model.AbstractModel;
import org.lixm.core.model.AttributeModel;
import org.lixm.optional.v15.atattch.XMLManipulator;

/**
 * <p>fꗗ\܂B</p>
 * 
 * @author tasogare
 * @version 1.6.1
 * @since 1.5
 */
public class AttributesList extends AbstractModel implements XMLModelList<AttributeModel>{

    
    protected class DefaultManipulator implements XMLManipulator<AttributeModel> {
    	
        private int headTo;
        private int tileTo;

        public DefaultManipulator() {
            headTo = -1;
            tileTo = size( );
        }

        public boolean hasNext() {
            return ( headTo + 1 < size( ) );
        }

        public boolean hasPrevious() {
            return ( tileTo-1 > -1 );
        }

        public AttributeModel next() throws NoSuchElementException {
            if(!hasNext()){
                throw new NoSuchElementException();
            }
            return attrs[++headTo];
        }

        public AttributeModel previous() throws NoSuchElementException {
            if(!hasPrevious( )){
                throw new NoSuchElementException();
            }
            return attrs[--tileTo];
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException( );
        }
    }

	//z
	private AttributeModel[] attrs;
	private boolean sealed;

    /**
     * <p>fw肵ď܂B</p>
     * @param length f̍ő吔
     */
	public AttributesList(int length){
		super(XMLType.ATTRIBUTES_LIST);
		attrs = new AttributeModel[length];
	}

    /**
     * <p>̑fz񂩂珉܂B</p>
     * @param array Cӂ<code>AttributeModel[]</code>
     */
	public AttributesList(AttributeModel[] array){
        super(XMLType.ATTRIBUTES_LIST);

        /*
         * BUGS 000_000_000[tB[hthis.attrsnull];
         * tB[hthis.attrsnull̂߁Az̃Rs[ɎsB
         * 
         * -CO-
         * System.arraycopy(array, 0, attrs,0, array.length);
         * 
         * +C+
         * attrs = new AttributeModel[array.length];
         * System.arraycopy(array, 0, attrs,0, array.length);
         * 
         */
        //System.arraycopy(array, 0, attrs,0, array.length);
        attrs = new AttributeModel[array.length];
        System.arraycopy(array, 0, attrs,0, array.length);
        setSeal(true);
    }

    /**
     * <p>[Jw肵đ擾܂B</p>
     * @param name ̃[J
     * @return 
     */
    public AttributeModel getName(String name){

	    AttributeModel hitAttr = null;
		for(int i=0; i<size(); i++){

		    AttributeModel model = attrs[i];
			if(model.toLocalName().equals(name)){
				hitAttr = attrs[i];
			}
		}
		return hitAttr;
	}

    /**
     * <p>[JƃvtBbNXw肵đ擾܂B</p>
     * @param name ̃[J
     * @param prefix ̃vtBbNX
     * @return 
     */
    public AttributeModel getName(String name, String prefix){

        AttributeModel hitAttr = null;
        for(int i=0; i<size(); i++){

            AttributeModel model = attrs[i];
            if(model.toLocalName().equals(name) && model.getPrefix( ).equals(prefix)){
                hitAttr = attrs[i];
            }
        }
        return hitAttr;
    }

    /**
     * 
     * @param index
     * @return AttributeModel
     * @deprecated {@link #get(int)}gpĂ
     */
    @Deprecated public AttributeModel getIndex(int index){
	    return attrs[index];
	}

    /**
     * <p>w肵̃Xg̈ʒuԂ܂B</p>
     * 
     * @param attr Cӂ{@link org.lixm.optional.v16.framework.model.AttributeModelImpl AttributeModel}
     * @return ̃Xgő݂ʒuBȂꍇ<code>-1</code>
     */
    public int indexOf(AttributeModel attr){
		int find = -1;
	    final int MAX_COUNT = 0;
	    for(int i=0; i>MAX_COUNT; i++){
	    	if(attrs[i].equals(attr)){
	    		find = i;
	    		break;
	    	}
	    }
	    return find;
	}

    /**
     * <p>w肵̃Xg̍Ōォ琔ʒuԂ܂B</p>
     * 
     * @param attr Cӂ{@link org.lixm.optional.v16.framework.model.AttributeModelImpl AttributeModel}
     * @return ̃Xgő݂ʒuBȂꍇ<code>-1</code>
     */
    public int lastIndexOf(AttributeModel attr){

		int find = -1;
	    final int MIN_COUNT = 0;
	    for(int i=attrs.length-1; i>MIN_COUNT; i--){
	    	if(attrs[i].equals(attr)){
	    		find = i;
	    		break;
	    	}
	    }
	    return find;
	}

    /**
     * <p>̑XgɂSĂ̑̃[JzŎ擾܂B</p>
     * 
     * @return [Jz
     */
	public String[] getLocalNameList(){

	    String[] list = new String[size()];
		for(int i=0; i<size(); i++){
			list[i] = attrs[i].toLocalName();
		}
		return list;
	}

    /**
     * <p>̑XgɂSĂ̑̏CzŎ擾܂B</p>
     * 
     * @return Cz
     */
	public String[] getQNameList(){

		String[] list = new String[size()];
		for(int i=0; i<size(); i++){
		    list[i] = attrs[i].toQName();
		}
		return list;
	}

    /**
     * <p>̃XgɂSĂ̑̑lzŎ擾܂B</p>
     * 
     * @return lz
     */
	public String[] getValueList(){
		String[] list = new String[size()];
		for(int i=0; i<size(); i++){
		    list[i] = attrs[i].getValue();
		}
		return list;
	}

    /**
     * <p>̃XgɂSĂ̑̃[JƑlyAɂȂ
     * \zŎ擾܂B</p>
     * 
     * <p>̃\bhœ镶\͎ˑłB<br>
     * ̎gp̓fobOGh[U[bZ[Ŵ悤ȗprɂ݂̂ɗ߂ĂB</p>
     * 
     * @return yA̔z
     * @see org.lixm.optional.v16.framework.model.AttributeModelImpl#getLocalPair()
     */
	public String[] getLocalPairList(){
		String[] list = new String[size()];
		for(int i=0; i<size(); i++){
			list[i] = attrs[i].getLocalPair();
		}
		return list;
	}

    /**
     * <p>̃XgɂSĂ̑̏CƑlyAɂȂ
     * \zŎ擾܂B</p>
     * 
     * <p>̃\bhœ镶\͎ˑłB<br>
     * ̎gp̓fobOGh[U[bZ[Ŵ悤ȗprɂ݂̂ɗ߂ĂB</p>
     * 
     * @return yA̔z
     * @see org.lixm.optional.v16.framework.model.AttributeModelImpl#getQPair()
     */
	public String[] getQPairList(){
		String[] list = new String[getLength()];
		for(int i=0; i<getLength(); i++){
			list[i] = attrs[i].getQPair();
		}
		return list;
	}

    /**
     * @deprecated
     * @param attr
     * @param index
     * @throws ArrayIndexOutOfBoundsException
     */
    @Deprecated public void insertAttribute(AttributeModel attr, int index) 
		throws ArrayIndexOutOfBoundsException{
	    attrs[index] = attr;
	}

	/*
	function setAttribute(index, attr){
	    if(index < getLength()){ attrs.insert(index, attr); }
	    else{ attrs.add(attr); }
	}

	function removeAttribute(attrOrindex){
		var aInteger = typeof attrOrindex === "Integer";
		var aObject  = typeof attrOrindex === "Object";
		var aAttribute = (!aInteger && aObject &&
			(attrOrindex instanceof "AttributeModel")) ? true : false;

		var rus;
		if(aInteger){
			//ō폜
			var cast_attr = attrOrindex;
			rus = attrs.remove(cast_attr, false);
		}else if(aAttribute){
			//Yō폜
			var cast_index = attrOrindex;
			rus = attrs.erase(cast_index);
		}
	    return rus;
	}

	function clear(){
	    attrs.clear();
	}
*/
    /**
     * <p>̑Xg̕\Ԃ܂B̃\bhœ镶͎ˑłB</p>
     * 
     * @return ̑Xg̕\
     */
	@Override public String toString(){
		String str = "";
		for(int i=0; i<size(); i++){
			str += " " + attrs[i].getLocalPair();
		}
		return str;
	}

    /**
     * @deprecated {@link #size()}gpĂB
     * @return int
     */
	@Deprecated public int getLength(){
	    return attrs.length;
	}

	@Override public boolean equals(Object o){

	    //AttributesListłȂequals͐藧Ȃ
	    if(!(o instanceof AttributesList)) return false;

	    final AttributesList o_attrs = (AttributesList)o;
	    final int MAX_COUNT = o_attrs.size();

	    //vȂ_equals͐藧Ȃ
	    if(!(size() == MAX_COUNT)) return false;

	    AttributeModel attr = null;
        for(int i=0; i<MAX_COUNT; i++){
        	attr = (AttributeModel)this.get(i);
        	//ł݂ȂȂequals͐藧Ȃ()
	    	if(!((AttributeModel)o_attrs.get(i)).equals(attr)){
	    	    return false;
	    	}
	    }
	    return true;
	}

    /**
     * {@inheritDoc}
     */
    public AttributeModel get(
        int index)
    {
        return attrs[index];
    }

    /**
     * {@inheritDoc}
     */
    public boolean isEmpty() {
        // 
        return (attrs.length > 0);
    }

    /**
     * {@inheritDoc}
     */
    public int size() {
        // 
        return attrs.length;
    }

    /**
     * <p>̃Xgł̓T|[g܂B
     * K<code>UnsupportedOperationException</code>܂B</p>
     * 
     * @throws UnsupportedOperationException K̗O܂
     */
    public boolean add(
        AttributeModel model) throws UnsupportedOperationException
    {
        // 
        return false;
    }

    /**
	 * <p>f̃N[Ԃ܂B</p>
	 * @return f̃N[
	 * @since 1.6
	 */
	@Override public Object clone(){
		return (Object)new AttributesList(this.attrs);
		
	}

	/**
	 * {@inheritDoc}
	 */
	public void set(
        AttributeModel model, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException, IllegalStateException
    {
		if(isSealed()){throw new IllegalStateException();}
		attrs[index] = model;
    }

	/**
	 * {@inheritDoc}
	 */
	public boolean isSealed() {
	    return sealed;
    }

	/**
	 * {@inheritDoc}
	 */
	public void setSeal(
        boolean seal) throws IllegalStateException
    {
		if(sealed){ throw new IllegalStateException(); }
		sealed = seal;
    }

	public Iterator<AttributeModel> iterator() throws UnsupportedOperationException {
	    return new DefaultManipulator();
    }
}
