package org.lixm.core.list;

import org.lixm.core.model.AbstractModel;

/**
 * <p>J[\̓Xg̃f̈ʒuJvZ܂
 * ꎩgł̓f擾ł܂B
 * ̓_ŃCe[^Ƃ͈Ⴂ܂B</p>
 * 
 * @author tasogare
 * @see XMLDocumentList
 * @version 1.6.1
 * @since 1.5
 */
public interface XMLCursor {

    /**
     * Xg̏߂ɂ郂f̈ʒu擾܂B
     * 
     * @return ̖߂l͏<code>0</code>ɂȂ锤łB
     */
    public abstract int getFirst();

    /**
     * Xg̍Ōɂ郂f̈ʒu擾܂B
     * 
     * @return ̖߂l͏
     * <code>{@link XMLDocumentList#size() size()} - 1
     * </code>ɂȂ锤łB
     * @see XMLDocumentList#size()
     */
    public abstract int getLast();

    /**
     * <p>݈ʒüɂ郂f̈ʒu擾܂B</p>
     * 
     * <p>̎AʒuXV܂B
     * Xg̎̈ʒuɃfꍇA
     * <code>IndexOutOfBoundsException</code>𓊂܂B</p>
     * 
     * @return <code>current + 1</code>ƂȂlԂB
     * @throws IndexOutOfBoundsException
     *             hasNext()UԂꍇ
     * @see #next()
     * @see #hasNext()
     */
    public abstract int inc() throws IndexOutOfBoundsException;

    /**
     * ݈ʒüɂ郂f̈ʒu擾܂B
     * {@link #inc()}Ƃ̈Ⴂ͈ʒuXV܂B
     * 
     * @return <code>current + 1</code>ƂȂlԂB
     */
    public abstract int next();

    /**
     * ɑ݂Jn^O܂͏I^Öʒu擾܂B
     * 
     * @return ^Ofꍇ̈ʒu
     */
    public abstract int nextTag();

    /**
     * ݈ʒu猩Ĉ̈ʒuɂ܂f݂Ă邩ׂ܂B
     * 
     * @return Ƀf݂ĂȂ^A
     * ŖȂUԂ܂B
     * 
     * @see #inc()
     * @see #next()
     */
    public abstract boolean hasNext();

    /**
     * <p> ݈ʒüOɂ郂f̈ʒu擾܂B </p>
     * 
     * <p> ̎AʒuXV܂B
     * Xg̑ÖʒuɃfꍇA
     * <code>IndexOutOfBoundsException</code>𓊂܂B</p>
     * 
     * @return <code>current - 1</code>ƂȂlԂB
     * @see #previous()
     * @see #hasPrevious()
     */
    public abstract int dec() throws IndexOutOfBoundsException;

    /**
     * ݈ʒüOɂ郂f̈ʒu擾܂B
     * {@link #dec()}Ƃ̈Ⴂ͈ʒuXV܂B
     * 
     * @return <code>current - 1</code>ƂȂlԂB
     */
    public abstract int previous();

    /**
     * ȑOɑ݂Jn^O܂͏I^Öʒu擾܂B
     * 
     * @return ^Ofꍇ̈ʒu
     */
    public abstract int previousTag();

    /**
     * ݈ʒu猩ĈÖʒuɂ܂f݂Ă邩ׂ܂B
     * 
     * @return 
     * OɃf݂ĂȂ^AŖȂUԂ܂B
     * @see #dec()
     * @see #previous()
     */
    public abstract boolean hasPrevious();

    /**
     * <p>J[\݈̌ʒuݒ肵܂B
     * ̒l{@link #getIndex()}Ŏ擾ꍇ͐ΓIȈʒuƂȂA
     * {@link #inc()}ȂǂŎ擾ꍇ͂̃\bhŐݒ肵
     * ʒȗΓIȈʒuƂȂ܂B</p>
     * 
     * @param index
     *            ݒ肷ʒu
     * @throws IndexOutOfBoundsException
     *             Xg͈̔͂𒴂ꍇ <code>IndexOutOfBoundsException</code>܂B
     * @see #getIndex()
     * @see #resetIndex()
     * @see #inc()
     * @see #next()
     * @see #dec()
     * @see #previous()
     */
    public abstract void setIndex(
        int index) throws IndexOutOfBoundsException;

    /**
     * ݈ʒuԂ܂B
     * 
     * @return ݂̐ΓIȈʒu
     * @see #setIndex(int)
     * @see #resetIndex()
     */
    public abstract int getIndex();

    /**
     * ݈ʒuꂽƂ̏Ԃɖ߂܂B
     * 
     * @see #setIndex(int)
     * @see #getIndex()
     */
    public abstract void resetIndex();

    /**
     * Cӂ̈ʒuL܂B
     * 
     * @param index
     *            LʒuB
     * @throws IndexOutOfBoundsException
     *             Xg͈̔͊OȂ <code>IndexOutOfBoundsException</code>𓊂܂B
     * @see #getMark()
     */
    public abstract void setMark(
        int index) throws IndexOutOfBoundsException;

    /**
     * Lς݈ʒuԂ܂B
     * 
     * @return Lς݂̈ʒu
     * @see #setMark(int)
     */
    public abstract int getMark();

    /**
     * Lς݈ʒuꂽƂ̏Ԃɖ߂܂B
     * 
     * @see #getMark()
     */
    public abstract void resetMark();

    /**
     * ݈ʒuLACӂ̈ʒu݈ʒuɐݒ肵Ȃ܂B
     * 
     * @param pos
     *            ݒ肷錻݈ʒu
     * @throws IndexOutOfBoundsException
     *             Xg͈̔͂𒴂ꍇ <code>IndexOutOfBoundsException</code>܂B
     * @see #setMark(int)
     * @see #setIndex(int)
     */
    public abstract void seek(
        int pos) throws IndexOutOfBoundsException;

    /**
     * ̃J[\ɑΉ郊XgԂ܂B
     * 
     * @return ̃J[\ɑΉ郊Xg
     * @see XMLDocumentList
     */
    public abstract XMLDocumentList<? extends AbstractModel> getList();
}
