package org.lixm.core.model;

import org.lixm.core.common.XMLType;


/**
 * <p>終了タグをモデル化します。</p>
 * @author tasogare
 * @version 1.0M1
 */
public class EndTagModel extends AbstractModel {

    private ElementModel elem;

    public EndTagModel(
        ElementModel element)
    {
        super(XMLType.END_TAG);
        elem = element;
    }

    public String getName() {
        return getElement( ).getName( );
    }

    public ElementModel getElement() {
        return elem;
    }

     public void setElement(ElementModel elem){
    	 this.elem = elem;
    }

    public String toEndTag() {
        return toString( );
    }

    public String toString() {
        return "</" + getElement( ).toString( ) + ">";
    }

    public boolean equals(
        Object o)
    {
        if (!super.equals(o)) return false;
        return ( this.toString( ) == o.toString( ) );
    }
}
