package org.lixm.core.model;

import org.lixm.core.common.XMLType;


/**
 * <p>文字データをモデル化します。</p>
 * @author tasogare
 * @version 1.0.0
 */
public class CharactersModel extends AbstractModel {

    private String text;

    public CharactersModel(
        String text)
    {
        super(XMLType.CDATA);
        this.text = text;
    }

    /**
     * <p>文字データのテキストを設定します。</p>
     * 
     * @param text 新たな文字データのテキスト
     */
    public void setText(String text){
    	this.text = text;
    }

    /**
     * <p>文字データのテキストを取得します。</p>
     * 
     * @return 文字データテキスト
     */
    public String getText() {
        return text;
    }
}
