package org.lixm.core.model;

import org.lixm.core.common.XMLType;

/**
 * <p>CDATAセクションの終わりをモデル化します。</p>
 * @author tasogare
 * @version 1.0.0
 */
public class EndCdataModel extends AbstractModel {

    public EndCdataModel() {
        super(XMLType.END_CDATA);
    }

    /**
     * {@inheritDoc}
     */
    public String toString() {
        return "]]>";
    }

    /**
     * <p>モデルの同一性を論理的に調べその結果を返します。</p>
     * @return 同一のモデルなら<code>true</code>、違うなら<code>false</code>。
     */
    public boolean equals(
        Object o)
    {
        if (!super.equals(o)) return false;
        return ( this.toString( ) == o.toString( ) );
    }
}
