package org.lixm.optional.v10.atattch;

import org.lixm.core.common.LIXMException;
import org.lixm.core.model.AbstractModel;


/**
 * <p>ディスパッチャが送ってきたモデルを処理します。</p>
 * <p>モデルを処理する方法はレシーバの実装次第です。</p>
 * 
 * @author tasogare
 * @version 1.1.1
 * @since v08
 * @see #receive(AbstractModel)
 * @see XMLDispatcher
 *
 */
public interface XMLReceiver {

    /**
     * <p>ディスパッチャからモデルを受け取り、処理します。</p>
     * 
     * @param model ディスパッチャが送ってきた<code>XMLModel</code>です。
     * @see XMLDispatcher#dispath(XMLReceiver)
     */
    public void receive(AbstractModel model) throws LIXMException;
}
