package org.lixm.core.model;

import org.lixm.core.common.XMLType;

/**
 * <p>処理命令をモデル化します。</p>
 * @author tasogare
 * @version 1.1.2
 */
public class ProcessingInstructionModel extends AbstractModel {

    private String target;
    private String data;

    public ProcessingInstructionModel(
        String target, String data)
    {
        super(XMLType.PI);

        this.target = target;
        this.data = data;
    }

    /**
     * <p>ターゲットを取得します。</p>
     * @return ターゲット文字列
     */
    public String getTarget() {
        return target;
    }

    /**
     * <p>ターゲットを設定します。</p>
     * 
     * @param target 新たなターゲット
     */
    public void setTarget(String target) {
        this.target = target;
    }

    /**
     * <p>データを取得します。</p>
     * @return データ文字列
     */
    public String getData() {
        return data;
    }

    /**
     * <p>データを設定します。</p>
     * 
     * @param data 新たなデータ
     */
    public void setData(String data){
    	this.data = data;
    }

    /**
     * {@inheritDoc}
     */
    public String toString() {
        return "<?" + getTarget( ) + " " + getData( ) + "?>";
    }

    /**
     * <p>モデルの同一性を論理的に調べその結果を返します。</p>
     * @return 同一のモデルなら<code>true</code>、違うなら<code>false</code>。
     */
    public boolean equals(
        Object o)
    {
        if (!super.equals(o)) return false;
        return ( this.toString( ) == o.toString( ) );
    }

}
